/****************************************************************************
 *
 *      Program name : NTUMIN.C (VER 1.0)
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *      This is the main program (startup file). It  allows :
 *          1.	Selection of the various algorithms to used
 *	    2.	Options for keyboard data input or data input from a file
 *	It then reads the data from the input file, generates the minterms
 *      and attempt to minimize the function using the selected algorithm.
 *	(All algorithms are variation of the original LOGMIN algorithm.)
 *	It then prints out the input data plus the minimized solution.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>          /* TURBO C ONLY */


unsigned long mem2;         /* external var */

main()

{
   unsigned char   option, *readk(), *readf(), *logmin_a(), *logmin_b();
   unsigned char   *logmin_c(), *logmin_d(), *logmin_e(), *logmin_f();
   unsigned char   *logmin_g(), *logmin_h();
   unsigned char   *s, *a, *b, nspm, choice;
   unsigned short  n, mb, ncubes();
   unsigned long   m, mem1;
   void            fprtout(), fprtin(), errsound();
   char            again=1, infile[21], outfile[21], dummy[5];
   FILE            *in, *out;
   clock_t         clock(void), clk1, clk2, clk3;

/*** Print Copyright messages ***/
clrscr();
printf("\n\n\n			NTUMIN (LOGIC MINIMIZATION) VER 1.0\n");
printf("		        ===================================\n\n");
printf("	Copyright (c) 1992. All Rights Reserved. Nanyang Technological\n");
printf("	University.\n\n\n");

printf("	You are free to use, copy and distribute this software and its\n");
printf(" 	documentation providing that:\n\n");

printf("		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.\n\n");

printf("		IT IS NOT MODIFIED IN ANY WAY.\n\n");

printf("		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.\n\n\n");

printf(" 	This program is provided \"AS IS\" without any warranty, expressed or\n");
printf(" 	implied, including but not limited to fitness for any particular\n");
printf(" 	purpose.\n\n");

getch();

   while (again)                                      /* repeated running */
      {
	 mem1 = coreleft();   			 /* max memory space left */
	 mem2 = mem1;                            /* min memory space left */

	 clrscr();
	 printf("                      L O G I C    M I N I M I S A T I O N\n\n");
	 printf("                                   U S I N G              \n\n");
	 printf("                                  L O G M I N             \n\n\n\n");
	 printf("               ͻ\n");
	 printf("                                                                \n");
	 printf("                                ALGORITHM MENU                  \n");
	 printf("                                --------------                  \n");
	 printf("                       1. LOGMIN_A           5. LOGMIN_E        \n");
	 printf("                                                                \n");
	 printf("                       2. LOGMIN_B           6. LOGMIN_F        \n");
	 printf("                                                                \n");
	 printf("                       3. LOGMIN_C           7. LOGMIN_G        \n");
	 printf("                                                                \n");
	 printf("                       4. LOGMIN_D           8. LOGMIN_H        \n");
	 printf("                                                                \n");
	 printf("               ͼ\n\n\n");

	 printf("               Please choose one algorithm to run. (1 to 8) -> ");
	 scanf("%d", &choice);                              /* algorithm to run */
	 while (choice<1 || choice>8)                       /* do until 1 to 8 entered */
	    {
	       gets(dummy);
	       errsound();                                  /* sound alarm */
	       printf("               Please choose one algorithm to run. (1 to 8) -> ");
	       scanf("%d", &choice);                        /* algorithm to run */
	    }
	 clrscr();
	 printf("\n\n\n\n\n\n");
	 printf("               ͻ\n");
	 printf("                                                           \n");
	 printf("                            MENU FOR DATA ENTRY            \n");
	 printf("                            -------------------            \n");
	 printf("                          1.    Keyboard entry             \n");
	 printf("                                                           \n");
	 printf("                          2.    Data file entry            \n");
	 printf("                                                           \n");
	 printf("                          3.    EXIT                       \n");
	 printf("                                                           \n");
	 printf("               ͼ\n\n");

	 printf("\n               Please enter 1, 2 or 3 -> ");           /* prompt user */
	 scanf("%d", &option);      		           /* user's option */
	 while (option !=1 && option !=2 && option !=3)    /* do until 1 to 3 entered */
	    {
	       gets(dummy);
	       errsound();      			   /* sound alarm */
	       printf("\n               Please enter 1, 2 or 3 -> ");     /* prompt user */
	       scanf("%d", &option);      		   /* user's option */
	    }

	 if (option == 3)
	    exit(0);                                        /* exit to environment */
	 else if (option == 2)
	    {
	       gets(dummy);                                   /* clear keyboard buffer */
	       printf("\n               Enter input filename (in.dat) -> ");
	       gets(infile);                                  /* get infile */
	       if (infile[0]=='\0') strcpy(infile,"in.dat");  /* default as "in.dat" */

	       printf("\n               Enter output filename (out.dat) -> ");
	       gets(outfile);                                     /* get outfile */
	       if (outfile[0]=='\0') strcpy(outfile, "out.dat");  /* default as "out.dat" */
	    }
	 else                                               /* option == 1 */
	    {
	       printf("\n               Enter number of variables (1 - 255) -> ");
	       scanf("%d", &n);                             /* read no. of variables */
	       while (n<1 || n>255)                         /* max 255 */
		  {
		     gets(dummy);
		     errsound();
		     printf("\n               Enter number of variables (1 - 255) -> ");
		     scanf("%d", &n);                       /* read no. of variables */
		  }

	       printf("\nEnter ON array\n--------------\n");
	       readk(0,n);                                  /* read & save ON array */
	       printf("\nEnter DC array\n--------------\n");
	       readk(1,n);                                  /* read & save DC array */
	       strcpy(infile, "in.dat");                    /* infile default */

	       printf("\nEnter output filename (out.dat) -> ");
	       gets(dummy);                                      /* clear keyboard buffer */
	       gets(outfile);                                    /* get outfile */
	       if (outfile[0]=='\0') strcpy(outfile, "out.dat"); /* default as "out.dat" */
	    }

	 if ((in = fopen(infile, "r+")) == NULL)           /* open infile */
	    {
	       printf("Error opening file, %s\n", infile);
	       printf("Program Terminated - 1\n");
	       exit(0);
	    }

	 if ((out = fopen(outfile, "a")) == NULL)          /* open outfile */
	    {
	       printf("Error opening file, %s\n", outfile);
	       printf("Program Terminated - 2\n");
	       exit(0);
	    }

	 fprintf(out,"ON ARRAY\n");                    /* print labels */
	 fprintf(out,"--------\n");
	 fprtin(in, out, 0);                           /* print ON-array */
	 fprintf(out,"\n");

	 fprintf(out,"DC ARRAY\n");                     /* print labels */
	 fprintf(out,"--------\n");
	 fprtin(in, out, 1);                            /* print DC array */
	 fprintf(out,"\n");

	 rewind(in);                             /* reset file pointer */
	 clk1 = clock();                         /* timer on */

	 a = readf(in, a, 0);                    /* read ON array */
	 nspm = *(a+3);                          /* no. of byte/minterm */

	 if (nspm == 0)                          /* check for solution of all 'X' */
	    s = a;                               /* transfer solution */
	 else
	    {
	       mb = *(a+2)<<8 | *(a+1);          /* no. of minterms in ON-array */
	       m = mb*nspm+4;                    /* memory size required */

	       b = (unsigned char *) malloc(mb*nspm+4);    /* space for ON-array */
	       if (b == 0)
		  {
		     printf("Out of memory -- LM, *b\n");
		     printf("Program terminated - 3\n");
		     exit(0);
		  }
	       memcpy(b, a, m);                       /* make a copy of ON array */

	       a = readf(in, a, 1);                   /* read DC array  */
	       nspm = *(a+3);                         /* no. of bytes/minterm */

	       fclose(in);                             /* close infile */

	       if (nspm == 0)                         /* solution of all X or '-' */
		  {
		     free(b);                         /* free pointer */
		     s = a;                           /* transfer solution */
		  }
	       else
		  {
		     clk2 = clock();                  /* intermediate timer */

		     switch (choice)                  /* algorithm to run */
			{
			    case 1 : s = logmin_a(a,b);   /* original LOGMIN */
				     break;
			    case 2 : s = logmin_b(a,b);  /* modification A */
				     break;
			    case 3 : s = logmin_c(a,b);  /* Single phase, mod B */
				     break;
			    case 4 : s = logmin_d(a,b);  /* Single phase, mod C */
				     break;
			    case 5 : s = logmin_e(a,b);  /* Single phase, mod D */
				     break;
			    case 6 : s = logmin_f(a,b);  /* Single phase, mod E */
				     break;
			    case 7 : s = logmin_g(a,b);  /* Single phase, mod F */
				     break;
			    case 8 : s = logmin_h(a,b);  /* Single phase, mod G */
			}
		     clk3 = clock();                  /* timer off */
		  }
	    }

	 clrscr();
	 printf("\nMINIMUM COVER\n");               /* print labels (screen) */
	 printf("-------------\n");

	 fprintf(out,"\nMINIMUM COVER\n");          /* print labels (outfile) */
	 fprintf(out,"-------------\n");
	 fprtout(s,out);                            /* print solution array */
	 fprintf(out,"\n");
	 printf("\n");

	 printf("Minterms generation time = %f seconds\n",(float)(clk2-clk1)/CLK_TCK);
	 printf("Actual minimization time = %f seconds\n",(float)(clk3-clk2)/CLK_TCK);
	 printf("Cube Count = %d\n", ncubes(s));
	 printf("Runtime memory usage = %ld bytes\n\n",mem1-mem2);
	 printf("Results obtained running algorithm %d\n\n", choice);

	 fprintf(out,"Minterms generation time = %f seconds\n",(float)(clk2-clk1)/CLK_TCK);
	 fprintf(out,"Actual minimization time = %f seconds\n",(float)(clk3-clk2)/CLK_TCK);
	 fprintf(out,"Cube Count = %d\n", ncubes(s));
	 fprintf(out,"Runtime memory usage = %ld bytes\n\n",mem1-mem2);
	 fprintf(out,"Results obtained running algorithm %d\n\n", choice);
	 fprintf(out,"\n==================================================\n");

	 printf("\007\007");                                  /* run completed alarm */
	 printf("Do you want to minimize another array (Y/N)\n");
	 scanf(" %c",&again);
	 if (again != 'y' && again != 'Y') again = 0;         /* y and Y only */

	 free(s);                                             /* free pointer */
	 fclose(out);                                         /* close files */
	 
    }
}
