/****************************************************************************
 *
 *	Program Name : ADJACENT.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program generate the possible adjacent terms given the minterm.
 * 	It then computes the adjacency of the minterm based on the possible
 *	adjacent terms generated.
 *
 *	Returns pointer to an array containing :
 *		1.  no. of variables, n
 *		2.  adjacency, adj
 *		3.  no. of bytes/minterm, nspm
 *		4.  the given minterm
 *		5.  all adjacent terms
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

unsigned char   *adjacent(temp, a, limit)
unsigned char 	*a, *temp, limit;

{
   unsigned short  m;
   unsigned char   *c, *adjterm, n, adj, i, j, nspm;
   char            test;


   n    = *a;                           /* no. of variables */
   nspm = *(a+3);                       /* no. of storage per minterm */
   m  = *(a+2)<<8 | *(a+1);             /* no. of minterms in a */

   c = (unsigned char *)  malloc(nspm+4);       /* 4 bytes for header */
   if (c == 0)
      {
	 printf("Out of memory -- ADJACENT, *c\n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   *c = n;                                      /* no. of variables */
   *(c+3) = nspm;                               /* no. of bytes/minterm */

   memcpy((c+4), temp, nspm);           /* minterm added as 1st term in c */

   adjterm = (unsigned char *)  malloc(nspm+1);     /* temporary storage */
   if (adjterm == 0)
      {
	 printf("Out of memory -- ADJACENT, *c\n");
	 printf("Program terminated - 2\n");
	 exit(0);
      }

   adj = 0;                                /* adjacency reset to zero */

   for (i=0; i<n; i++)                     /* generate possible adj term */
      {
	 for (j=0; j<nspm; j++)            /* loop for nspm>1 */
	    {
	       if ((i/8) == j)
		  *(adjterm+j) = *(temp+j) ^ (1<<(i%8));   /* XOR */
	       else
		  *(adjterm+j) = *(temp+j);
	    }

	 test = exist(adjterm, a, m);       /* check for existence in a-array */
	 if (test == 0)                     /* exist in array a, an adj term */
	    {
	       adj++;                       /* increment adjacency */
	       if (adj > limit)             /* adjacency > limit */
		  break;
	       c = (unsigned char *) realloc(c, 4+nspm*(adj+1));  /* more space */
	       if (c == 0)
		  {
		     printf("Out of memory -- ADJACENT, *c\n");
		     printf("Program terminated - 3\n");
		     exit(0);
		  }

	       memcpy((c+4+nspm*adj), adjterm, nspm);  /* add adjacent term to c array */
	    }
      }

   *(c+1) = adj;                      /* update adjacency to c array */
   *(c+2) = 0;                        /* for use in reduce function */

   free(adjterm);                     /* free pointer */

   return(c);                         /* return minterm plus adjacent terms */
}


