/****************************************************************************
 *
 *	Program Name : ADJACENC.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program generate the possible adjacent terms given the minterm.
 * 	It then computes the adjacency of the minterm base on the possible
 *	adjacent terms generated.
 *
 *	Returns adjacency of the given minterm.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

unsigned char   adjacency(temp, a)
unsigned char 	*a, *temp;


{
   unsigned short  m;
   unsigned char   *adjterm;
   unsigned char   i, j, nspm, n, adj;
   char            test;


   n    = *a;                              /* no. if variables */
   nspm = *(a+3);                          /* no. of bytes/minterm */
   m  = *(a+2)<<8 | *(a+1);                /* no. of minterms */

   adjterm = (unsigned char *)  malloc(nspm+1);  /* temporary storage */
   if (adjterm == 0)
      {
	 printf("Out of memory -- ADJACENC, *adjterm\n");
	 printf("Program Terminated - 1\n");
	 exit(0);
      }

   adj = 0;

   for (i=0; i<n; i++)
      {
	 for (j=0; j<nspm; j++)        /* generate possible adjacent terms */
	    {
	       if ((i/8) == j)
		  *(adjterm+j) = *(temp+j) ^ (1<<(i%8));   /* XOR */
	       else
		  *(adjterm+j) = *(temp+j);
	    }

	 test = exist(adjterm, a, m);
	 if (test == 0)                      /* exist in a-array */
	    adj++;
      }

   free(adjterm);                            /* free pointer */

   return(adj);                              /* return adjacency */
}


