/* $Xukc: Xcoloredit.h,v 1.4 91/06/17 10:58:00 rlh2 Rel $ */

/* 
 * Copyright 1990 Richard Hesketh / rlh2@ukc.ac.uk
 *                Computing Lab. University of Kent at Canterbury, UK
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of Richard Hesketh and The University of
 * Kent at Canterbury not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.
 * Richard Hesketh and The University of Kent at Canterbury make no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * Richard Hesketh AND THE UNIVERSITY OF KENT AT CANTERBURY DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL Richard Hesketh OR THE
 * UNIVERSITY OF KENT AT CANTERBURY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Richard Hesketh / rlh2@ukc.ac.uk, 
 *                Computing Lab. University of Kent at Canterbury, UK
 */

static String app_defaults[] = {
/* global defaults */
	"*Foreground: black",
	"*Background: white",
	"*BorderColor: black",
/* For mixing form */
	"*mixingForm.translations: <Expose>: draw_boxed()",
/* For all scrollbars */
	"*Scrollbar.borderWidth: 2",
	"*Scrollbar.height: 255",
	"*Scrollbar.width: 15",
	"*Scrollbar.translations: \
 <Btn1Down>: border() StartScroll(Forward) \\n\
 <Btn2Down>: border() StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\
 <Btn3Down>: border() StartScroll(Backward) \\n\
 <Btn2Motion>: MoveThumb() NotifyThumb() \\n\
 <BtnUp>: border(reset) NotifyScroll(Proportional) EndScroll() update_triple()",
/* Red locked button */
	"*redLocked.width: 15",
	"*redLocked.height: 15",
	"*redLocked.label: ",
	"*redLocked.horizDistance: 5",
	"*redLocked.translations: <Btn1Down>: lock_toggle(red)",
/* Green locked button */
	"*greenLocked.width: 15",
	"*greenLocked.height: 15",
	"*greenLocked.label: ",
	"*greenLocked.fromHoriz: redLocked",
	"*greenLocked.horizDistance: 6",
	"*greenLocked.translations: <Btn1Down>: lock_toggle(green)",
/* Blue locked button */
	"*blueLocked.width: 15",
	"*blueLocked.height: 15",
	"*blueLocked.label: ",
	"*blueLocked.fromHoriz: greenLocked",
	"*blueLocked.horizDistance: 6",
	"*blueLocked.translations: <Btn1Down>: lock_toggle(blue)",
/* Title */
	"*title.label: XColoredit v1.2",
	"*title.borderWidth: 0",
	"*title.width: 187",
	"*title.height: 15",
	"*title.fromHoriz: blueLocked",
	"*title.vertDistance: 6",
/* Red Scroll bar */
	"*redScroll.foreground: red",
	"*redScroll.borderColor: red",
	"*redScroll.fromVert: redLocked",
/* Green Scroll bar */
	"*greenScroll.foreground: #4fb51e",
	"*greenScroll.borderColor: #4fb51e",
	"*greenScroll.fromHoriz: redScroll",
	"*greenScroll.fromVert: greenLocked",
/* Blue Scroll bar */
	"*blueScroll.foreground: blue",
	"*blueScroll.borderColor: blue",
	"*blueScroll.fromHoriz: greenScroll",
	"*blueScroll.fromVert: blueLocked",
/* Locked Scroll bar */
	"*lockedScroll.fromHoriz: blueScroll",
	"*lockedScroll.fromVert: title",
	"*lockedScroll.sensitive: false",
/* Mixed colour box */
	"*mixedColor.label: To change the\\n\
colour of this\\n\
example text\\n\
type \"c\" or \"t\"\\n\
in this window.",
	"*mixedColor.height: 148",
	"*mixedColor.width: 162",
	"*mixedColor.fromHoriz: lockedScroll",
	"*mixedColor.fromVert: title",
	"*mixedColor.translations: <Btn1Down>: set_scroll(red) \\n\
					     <Btn1Up>: stop_scroll(red) \\n\
					     <Btn2Down>: set_scroll(green) \\n\
					     <Btn2Up>: stop_scroll(green) \\n\
					     <Btn3Down>: set_scroll(blue) \\n\
					     <Btn3Up>: stop_scroll(blue) \\n\
					     <Key>c: change_text_colour() \\n\
					     <Key>t: change_text_colour() \\n\
					     <MotionNotify>: move_scroll()",
/* Red colour box */
	"*redIntensity.height: 50",
	"*redIntensity.width: 50",
	"*redIntensity.fromVert: mixedColor",
	"*redIntensity.fromHoriz: lockedScroll",
	"*redIntensity.translations: <Btn1Down>: set_scroll(red) \\n\
						<Btn1Up>: stop_scroll(red) \\n\
						<MotionNotify>: move_scroll()",
/* Green colour box */
	"*greenIntensity.height: 50",
	"*greenIntensity.width: 50",
	"*greenIntensity.fromVert: mixedColor",
	"*greenIntensity.fromHoriz: redIntensity",
	"*greenIntensity.translations: <Btn1Down>: set_scroll(green) \\n\
						 <Btn1Up>: stop_scroll(green) \\n\
						 <MotionNotify>: move_scroll()",
/* Blue colour box */
	"*blueIntensity.height: 50",
	"*blueIntensity.width: 50",
	"*blueIntensity.fromVert: mixedColor",
	"*blueIntensity.fromHoriz: greenIntensity",
	"*blueIntensity.translations: <Btn1Down>: set_scroll(blue) \\n\
						<Btn1Up>: stop_scroll(blue) \\n\
						<MotionNotify>: move_scroll()",
/* triple Value */
	"*tripleValue.label: #ffffff",
	"*tripleValue.width: 162",
	"*tripleValue.fromHoriz: lockedScroll",
	"*tripleValue.fromVert: redIntensity",
/* quit button */
	"*quit.label: Quit",
	"*quit.width: 162",
	"*quit.fromVert: tripleValue",
	"*quit.fromHoriz: lockedScroll",
/* hue label */
	"*hueLabel.label: H",
	"*hueLabel.fromHoriz: title",
	"*hueLabel.width: 15",
	"*hueLabel.height: 15",
	"*hueLabel.horizDistance: 6",
/* saturation label */
	"*satLabel.label: S",
	"*satLabel.fromHoriz: hueLabel",
	"*satLabel.width: 15",
	"*satLabel.height: 15",
	"*satLabel.horizDistance: 6",
/* value label */
	"*valLabel.label: V",
	"*valLabel.fromHoriz: satLabel",
	"*valLabel.width: 15",
	"*valLabel.height: 15",
	"*valLabel.horizDistance: 6",
/* hue scrollbar */
	"*hueScroll.fromHoriz: mixedColor",
	"*hueScroll.fromVert: hueLabel",
	"*hueScroll.translations: \
 <Btn1Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Forward) \\n\
 <Btn2Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\
 <Btn3Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Backward) \\n\
 <Btn2Motion>: MoveThumb() NotifyThumb() \\n\
 <BtnUp>: stop_scroll(red) stop_scroll(green) stop_scroll(blue) \
		NotifyScroll(Proportional) EndScroll() update_triple()",
/* saturation scrollbar */
	"*satScroll.fromHoriz: hueScroll",
	"*satScroll.fromVert: satLabel",
	"*satScroll.translations: \
 <Btn1Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Forward) \\n\
 <Btn2Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\
 <Btn3Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Backward) \\n\
 <Btn2Motion>: MoveThumb() NotifyThumb() \\n\
 <BtnUp>: stop_scroll(red) stop_scroll(green) stop_scroll(blue) \
		NotifyScroll(Proportional) EndScroll() update_triple()",
/* value scrollbar */
	"*valScroll.fromVert: valLabel",
	"*valScroll.fromHoriz: satScroll",
	"*valScroll.translations: \
 <Btn1Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Forward) \\n\
 <Btn2Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\
 <Btn3Down>: set_scroll(red) set_scroll(green) set_scroll(blue) \
		StartScroll(Backward) \\n\
 <Btn2Motion>: MoveThumb() NotifyThumb() \\n\
 <BtnUp>: stop_scroll(red) stop_scroll(green) stop_scroll(blue) \
		NotifyScroll(Proportional) EndScroll() update_triple()",
/* color box */
	"*colorBox.fromVert: redScroll",
	"*colorBox.borderWidth: 0",
	"*colorBox.horizDistance: 0",
/* memory buttons */
	"*colorMemory.width: 22",
	"*colorMemory.height: 22",
	"*colorMemory.borderWidth: 1",
	"*colorMemory.borderColor: black",
	"*colorMemory.translations: <Btn1Down>: pick_memory()"
};
