
//================================================
// read_sec()
//================================================
int read_sec(uchar far *buffer, ulong sectornumber, int type)
{
// far *buffer - pointer to where I stuff the sector data
// ulong sectornumber - need I say more
// int type - if 0 - interpret the sector number without an offset
//                   to the partition
//            if 1 - add in the offset to the partition.
uint result, track, sec, hd;
ulong cylinder, spp;

spp = (ulong)hdb.short_number_sectors_partition;
if( spp == 0L )
	spp = (ulong)hdb.number_sectors_partition;

if( sectornumber > spp )
		{
		printf("\n\rSector number too large");
		getch();
		exit(0);
		}

if( type == 1 )
	sectornumber += (ulong)hdb.number_hidden_sectors;

// since the only call to this function is the sector number we need to
// convert this to sector number, cyl, and head.

// first get the sector number for this track
sec = (uint)((sectornumber % hdb.sectors_track) + 1);// sector number
// no get the tracks*heads by dividng by the sectors per track
cylinder = sectornumber / (ulong) hdb.sectors_track;
// the head number is found by moding the cylinder by the number of heads
hd = (uint)(cylinder % (ulong)hdb.number_heads );	// head number
// the track is found by dividing the cylinder by the number of heads
track = (uint)(cylinder / ((ulong)hdb.number_heads));

mydisk.drive = (uint)current_drive;
mydisk.head = hd;
mydisk.track = track;
mydisk.sector = sec;
mydisk.nsectors = 1;
mydisk.buffer = buffer;
result = _bios_disk( _DISK_READ, &mydisk );
if( (result & 0xff00) != 0)
	{
	printf("\n\rRead Error for sector # %ld",sectornumber);
	getch();
	exit(0);
	}
// the data is in buffer, 512 bytes.
return result;
}


