/*-
 * MSDOS routine for getting the working directory on a specified drive.
 * By Barry Schwartz, 12 August 1990
 */

#include <stddef.h>
#include <dos.h>


#undef LARGE_DATA
#if defined(M_I86CM) || defined(M_I86LM) || defined(M_I86HM)
#define LARGE_DATA
#endif


static union REGS inregs, outregs;
#ifdef LARGE_DATA
static struct SREGS segregs;
#endif



/*
 * get_working_directory(buf, drive) Returns buf, or NULL if the drive
 * specification is invalid. 
 */

char           *
get_working_directory(buf, drive)
char           *buf;		/* Pointer to a buffer of sufficient size
				 * (_MAX_DIR) */
int             drive;		/* Drive number (0=default, 1=`A:',
				 * 2=`B:', etc.) */
{
    inregs.h.ah = 0x47;		/* DOS interrupt number */
    inregs.h.dl = drive;
#ifdef LARGE_DATA
    inregs.x.si = FP_OFF(buf);	/* SI points to buf within the segment */
    segregs.ds = FP_SEG(buf);	/* DS points to the segment */
    intdosx(&inregs, &outregs, &segregs);
#else
    inregs.x.si = (unsigned int) buf;
    intdos(&inregs, &outregs);
#endif
    if (outregs.x.cflag)
	return NULL;
    return buf;
}



#ifdef TEST


#include <stdlib.h>


char            working_dir[_MAX_PATH];


main()
{
    int             drive;
    char           *result;

    for (drive = 0; drive != 10; ++drive)
    {
	result = get_working_directory(working_dir, drive);
	if (result)
	    printf("drive = %2d        working directory = %s\n",
		   drive, result);
	else
	    printf("drive = %2d        invalid drive specification\n",
		   drive);
    }
}


#endif
