;------------------------------------------------------------------------
; purge.asm	from "PC MAGAZIN" #3 vom 8-Jan-86
;		plus quite a few hours from a non-assembler-programmer
;		Hans ZURFCC::ZANGGER, SWAS Kloten
;
;	BUG:	if purge with just a trailing space and CR is given
;		beautiful things happen (why not reboot from time to time?)
;
;		..Was in PARSE which didn't check for End-of-String
;
;	Code - by the way is VERY CLUMSY - this ain't one of the better
;	examples of assembly language coding ...
;
;	Since code 'rides' on assumption, that 'STACK' handling is supplied
;	by 'lower-levels' - U need to follow :
;	MASM PURGE;		!Assemble
;	LINK PURGE;		!Link and ignore Warning about missing STACK
;	EXE2BIN PURGE.EXE PURGE.COM ! Make it non-relocatable/-sharable
;	DEL PURGE.EXE		!Get rid of LINK results
;	DEL PURGE.OBJ		!.. and MASM results.
;							{B.E. 26-Nov-86}
;9 Oct 88
; - Tightened code
; - Changed some MASM-reserved words (out
; David Kirschbaum
; Toad Hall
; kirsch@braggvax.ARPA
;------------------------------------------------------------------------
;
cseg	segment 'code'
	assume cs:cseg, ds:cseg, es:cseg, ss:cseg

	org 5ch
drive	equ this byte

	org 80h
command_tail   equ this byte

	org 100h

CR		equ	0DH
LF		equ	0AH
LAST_BYTE	equ offset buffer
FOUND_FILE	equ offset fcb + 30
NORMAL		equ 20h
DIR		equ 10h
;
display macro	string
	mov	dx, offset string
	mov	ah, 09h
	int	21h
endm
;
read_kbd  macro
	mov	ah, 08h
	int	21h
endm
;
display_char  macro  character
	mov	dl, character
	mov	ah, 02h
	int	21h
endm
;
;------------------------------------------------------------------------
main:	jmp entry
;------------------------------------------------------------------------
help_msg	db CR,LF,'Purge files (Nov 86 hz/Oct 88 th).', 09h
		db 'Enter Y, N or F11 (ESC)'
crlf		db CR,LF,'$'				;share this	v1.1
spruch		db 'Delete file: $'
bad_vers	db 'Wrong DOS Version (must be V2.xx or higher)$'
bad_drive	db 'Bad Drive$'
r_only		db 'Access Denied$'			;v1.1
i_path		db 'File not found...$'			;v1.1
syntax_error	db CR,LF,'Use PURGE [drv:]filnam.ext$'
search_string	db 0, ':', 77 dup (0), '$'
file_name	db 13 dup (0)
kill_file	db 80 dup (0)
found_flag	db 0
dir_level	dw 0
len		db 0
stardotstar	db '*.*', 0
dta_pointer	dw LAST_BYTE + 64
deleted		db 'Yes$'
notdeleted	db 'No$'
abort_it	db 'aborted',CR,LF,'$'			;added CR/LF	v1.1

;------------------------------------------------------------------------
entry:
	cmp	byte ptr [command_tail], 0
	jne	Bytes_Da
	 mov	dx,offset syntax_error	;'Use PURGE [drv:]filnam.ext'	v1.1
	 jmp	short Err_End		;display msg, terminate		v1.1

Bytes_Da:
	cmp	al, 0ffh
	jnz	Drive_Ok
	 mov	dx,offset bad_drive	;'Bad drive'			v1.1
Err_End:
	mov	ah, 09h
	int	21h
Endit:	mov	ah, 4ch
	int	21h

Drive_Ok:
	mov	ah, 30h			;get current DOS version
	int	21h
	cmp	al, 02h			;2.0 or above?
	jnb	Vers_Ok			;yep, ok
	 mov	dx,offset bad_vers	;'Wrong DOS version'
	 jmp	short Err_End		;display, die

Vers_Ok:
	display help_msg		;'Purge files...'
	mov	al, [drive]		;get drive
	or	al, al			;anything there?
	jnz	Not_Default		;yep, user specified
	 mov	ah, 19h			;use current drive
	 int	21h
	 inc	al			;adjust

Not_Default:
	add	al, 40h			;Asciify drive char
	mov	search_string[0], al	;stuff in string
	mov	cl, byte ptr [command_tail]
	xor	ch, ch
	mov	si, cx
	add	si, offset command_tail
	mov	di, offset file_name
	mov	bx,':' SHL 8 + '\'		;		v1.1
	dec	cx
	call	Parser
	mov	byte ptr [di], 0
	inc	si
	cmp	byte ptr [si], '\'
	je	Get_Path
	 mov	di, offset search_string + 2
	 jmp	short Entry_Done

Get_Path:
	mov	di, offset search_string + 2	;parse path
	mov	bl, 20h				;stop at space
	inc	cx
	call	Parser				;read path

Entry_Done:
	display crlf
	xor	bx, bx
	mov	word ptr [bx + LAST_BYTE], di	;write first parameter
						; in pointer chain
	mov	dx, offset search_string	;pointer to search string
						; for Find_Files
	mov	si, offset file_name
	call	Find_Files			;search first level

Set_Up_Dir_Find:
	mov	bx, dir_level			;dir_level points to pointer
						; table of offsets for current
						;  path
	shl	bx, 1
	mov	di, word ptr [bx + LAST_BYTE]	;point to end
	mov	si, offset stardotstar		;current search pat in di
	movsw					;move 4 chars		v1.1
	movsw					;			v1.1
;Find_Dirs:
	mov	dx, dta_pointer
	mov	ah, 1ah				;function set dta
	int	21h
	cmp	found_flag, 1			;found something before?
	jz	Find_Next
	 mov	dx, offset search_string	;else set pointer and
	 mov	cx, DIR				; attribute and search
	 mov	ah, 4eh
	 int	21h
	 jmp	short Check_Carry

Find_Next:
	mov	ah, 4fh				;find next
	int	21h

Check_Carry:
;	jnc	Found_One			;no carry -> found entry
;	 jmp	short Check_Level		;searched all dirs yet?
	jb	Check_Level			;didn't find it,	v1.1
						;searched all dirs yet?	v1.1
;found entry processing and discarding of . and ..
;Found_One:
	mov	si, dta_pointer			;point to found entry
	add	si, 1eh
	cmp	byte ptr [si - 1eh + 15h], DIR  ;is it a directory?
	jne	Find_Next
	cmp	byte ptr [si], '.'		;not the ones we want
	je	Find_Next
	mov	found_flag, 1
	mov	di, word ptr [bx + LAST_BYTE]	;point to end of search_string

;process string
Look4Z:
	lodsb					;read chars
	or	al,al				;null char found?	v1.1
	je	Found_Z				;yes
	 stosb					;move byte
	 jmp	short Look4Z

Found_Z:
	mov	byte ptr [di], '\'		;append backslash
	inc	di
	inc	bx				;bump by 2		v1.1
	inc	bx				;			v1.1
	mov	word ptr [bx + LAST_BYTE], di	;update pointer table
	mov	dx, offset search_string	;set pointer for Find_Files
	mov	si, offset file_name
	call	Find_Files

;update pointers and variables, search next directory entry

;Update:
	add	dta_pointer, 43			;update dta pointer
	inc	dir_level			;down one level
	mov	found_flag, 0			;start on new level
	jmp	Set_Up_Dir_Find

Check_Level:
	dec	dir_level
	cmp	dir_level, -1
	jz	AllDone				;this stops the game
	 sub	dta_pointer, 43			;else adjust dta pointer
	 mov	found_flag, 1
	 jmp	Set_Up_Dir_Find			; and continue searching

AllDone:
	jmp	Endit				;terminate		v1.1

;------------------------------------------------------------------------
Parser  proc	near
;------------------------------------------------------------------------
	xor	ax, ax
	push	ax			;null as mark onto stack
	std				;set reverse

Parse_Loop:
	lodsb					;load byte in al
			;First check if we're at end-of-string {B.E}
	or	al,al			;Is it null?		v1.1
	je	Parse_Done
	cmp	al, bh			;Scan for 1st requ. Break-Char
	je	Parse_Done
	cmp	al, bl			;Scan for 2nd one
	je	Parse_Done
	cmp	al, 'z'			;Check for 'lower-case'
	ja	Push_Byte
	cmp	al, 'a'			;Not really necessary ..
				        ;but since DOS uppercases already
	jb	Push_Byte
	 xor	al, 20h			;UPPERcase

Push_Byte:
	push	ax
	loop	Parse_Loop

Parse_Done:
	cld				;set forward
Pop_AX: pop	ax
	or	ax,ax			;v1.1
	je	End_Parse
	 stosb
	 jmp	short Pop_AX

End_Parse:
	ret
Parser  endp

;------------------------------------------------------------------------
Find_Files proc near
;------------------------------------------------------------------------
;	dx points to current pathname
;	si    "   "  file name (search pattern)
;	di    "   "  first byte after pathname
;------------------------------------------------------------------------

	mov	bp, dx			;save dx
	mov	bx, di			;save di
	mov	dx, offset fcb
	mov	ah, 1ah			;set dta
	int	21h
	mov	cx, 13			;add 13 chars after pathname
	rep	movsb
	xor	al, al
	stosb				;make asciiz
	mov	dx, bp
	mov	cx, NORMAL
	mov	ah, 4eh			;find first
	int	21h
	jc	Not_Found
;
Show_It:
	mov	byte ptr [bx], 0	;mark end of pathname
	mov	dx, bp
;+++
	cld
	mov	si, bp
	mov	di, offset kill_file
	mov	cx,32			;move 64 bytes as words	v1.1
	rep	movsw			;			v1.1
	mov	di, offset kill_file
	mov	cx, 64
	xor	al, al
	repne	scasb			;find end of pathname
	dec	di
	push	di
;---
	mov	dx, FOUND_FILE		;extract filename
	mov	di, offset fcb		;dest for stosb
	add	di, 30			;skip over fcb dir entry
					; see page 1-136
	xor	al, al			;clear out al for scasb
	mov	cx, 12			;move 12 chars
	repne	scasb			;search for null char
	rep	stosb

;+++
	mov	si, FOUND_FILE
	pop	di
	mov	cx, 13
	rep	movsb
	mov	di, offset kill_file
	mov	cx, 64
	xor	al, al
	repne	scasb
	dec	di
	mov	byte ptr [di], '$'
;v1.1 No reason to save DI, nothing bothers it...
;	push	di
	display spruch			;'Delete file?'
	call	Lower_Case
	display kill_file		;show pathname
	call	Spaces
;	pop	di
	mov	byte ptr [di], 0	;make string asciiz
	call	YesNo
	display crlf
;---
	mov	dx, bp
	mov	ah, 4fh			;find next
	int	21h
	jnc	Show_It

Not_Found:
	ret
Find_Files	endp

;------------------------------------------------------------------------
Delete_File	proc near
;------------------------------------------------------------------------
	mov	ah, 041h
	mov	dx, offset kill_file
	int	21h
	mov	dx,offset deleted	;'Yes' (assume success)	v1.1
	jnc	Show_Results		;display, return	v1.1
	 mov	dx,offset i_path	;assume 'File Not Found' v1.1
	 cmp	al, 2			;invalid path
	 je	Show_Results		;display, return	v1.1
	  mov	dx,offset r_only	;assume 'Access Denied'	v1.1
					;(error 5)
Show_Results:
	mov	ah,9			;display msg		v1.1
	int	21H
	ret
Delete_File	endp

;------------------------------------------------------------------------
Lower_Case	proc near
;------------------------------------------------------------------------
;v1.1 No reason not to use AL.  Changed DL to AL.
	mov	bx, offset kill_file	;get string to lowercase
Start_Lower:
	mov	al, [bx]
	cmp	al, '$'
	je	lwr_done		;end of string?
	cmp	al, 'A'
	jl	Skip_Char
	cmp	al, 'Z'
	jg	Skip_Char
	 or	 al, ' '
	 mov	 byte ptr [bx], al	;put char back into string
Skip_Char:
	inc	bx
	loop	Start_Lower		;loop for all chars
lwr_done:
	mov	ax,bx
	xor	ah,ah			;clear msb
	mov	len,al			;stuff length
	ret

Lower_Case	endp

;------------------------------------------------------------------------
YesNo	proc near
;------------------------------------------------------------------------
;v1.1 No need to save AX
	mov	dl,'?'			;display '?'			v1.1
	mov	ah,2			;display char			v1.1
	int	21H
	mov	dl,8			;and backspace			v1.1
	int	21H			;AH wasn't changed		v1.1
	mov	cx, 1			;maximum length of entry (y/n)
	read_kbd
;display_char al
	cmp	al, 'y'
	je	Delete_It
	cmp	al, 'Y'
	je	Delete_It
	cmp	al, 27			;escape or F11
	je	Abort_Show
	display notdeleted		;'No'
	ret

Delete_It:
	call	Delete_File
	ret

Abort_Show:
	mov	dx,offset abort_it	;'Aborted'		v1.1
	jmp	Err_End			;display, die		v1.1

YesNo	endp

;------------------------------------------------------------------------
Spaces		proc near
;------------------------------------------------------------------------
;v1.1 Could use a bios call here to display multiple chars,
;but might as well stay standard...
	mov	ax,60		;max len		v1.1
	sub	al,len		;- string's length	v1.1
	mov	len,al		;new length		v1.1
	mov	cx,ax		;use as counter		v1.1
	mov	dl,' '		;display a space	v1.1
	mov	ah,02H
	int	21H
	mov	dl, '.'		;display a dot		v1.1
Disp:				;			v1.1
	int	21h		;AH isn't changed	v1.1
	loop	Disp
	ret
Spaces  endp

;------------------------------------------------------------------------
;
fcb	label	byte			;43-byte FCB		v1.1
buffer	equ	fcb+43			;			v1.1

cseg	ends
	end main
