/*******************************************************************************

                               ndel(tm) v0.0

    COPYRIGHT:  This program is the sole property of Thomas D. Haynes.
                            Copyright 1991.

    DISCLAIMER: While it was compilied with Turbo C++, it will work
                in Turbo C, and if you change the findfirst and
                findnext functions to the corresponding MSC functions,
                it ought to work with MSC.

                Use of this product waives the author of any responsibilty
                of damage.  Face it, I've tested this software on my
                system, and if it wiped out my hard disk, I'd be sure
                to rewrite the code so that I could use it safely.
                (Okay, so it wiped out my c source directory when I
                tested it.  But, it _won't_ do that again.)

    AUTHOR:     Thomas D. Haynes

    FILE:   ndel        TYPE:   void              PROTOTYPE FILE:   N/A

    PURPOSE:    To delete all files from a directory except those specified.

    DATE:       02/25/91

    LANGUAGE:   Turbo C++ v1.00

    FUNCTIONS CALLED:
                input_error

    LIBRARY FUNCTIONS CALLED:
                chmod               <io.h>
                findfirst           <dir.h>
                findnext            <dir.h>
                memset              <string.h>
                perror              <stdio.h>
                remove              <stdio.h>
                strcat              <string.h>
                strcmp              <string.h>
                strcpy              <string.h>

    RETURN CODES:
                -1 if bad command line format

    OTHER:
                ndel -x ext1 ext2 ... ext(n-1) extn -f file1 file2 ...
                    file(m-1) filem

                Where ext is the file extension of those files you wish
                to save, and file is the filename minus the extension of
                those files you wish to save.

           Turbo C++ is a Copyright of Borland International

*******************************************************************************/

#define NDEL_ROOT_LEN           3
#define NDEL_EXT                1
#define NDEL_FILE               2

#define NDEL_FALSE              0
#define NDEL_TRUE               1

#define NDEL_FILE_LEN          13
#define NDEL_MAX_ENT          512

void input_error(void);

#include <dir.h>
#include <sys\stat.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

static char *mine[] =
    {
    "COPYRIGHT:  This program is the sole property of Thomas D. Haynes.",
    "                     ALL RIGHTS RESERVED                          ",
    "                        Copyright 1991.                           "
    };

void input_error(void)
{
    printf("\nndel -x <extension(s)> -f <filename(s)>\n");
    exit (-1);
}

void main(int argc, char *argv[])
{
    char sav_file[NDEL_FILE_LEN];   /* string containing arg for finds      */
    struct ffblk ffblk_st;          /* structure containg found info        */
    int i;                          /* loop variable                        */
    int done;                       /* flag if all files found              */
    int type;                       /* flag for either -x or -f             */
    int retcde;                     /* return of calls                      */
    int index = 0;                  /* index on save array                  */
    int okay_to_del;                /* flag for okay to delete              */
    char sav_ar[NDEL_MAX_ENT][NDEL_FILE_LEN];
                                    /* array of files to save               */
    extern int errno;               /* external error code                  */

    if (argc <= 2)
        {
        perror("\nargc <= 2");
        input_error();
        }

    if (!strcmp(argv[1], "-x"))
        type = NDEL_EXT;
    else if (!strcmp(argv[1], "-f"))
        type = NDEL_FILE;
    else
        input_error();

    /*  Parse the command line, getting patterns to block out
        of the file deletion process                                        */

    for ( i = 1 ; i <= argc ; i++)
        {
         if (((!strcmp(argv[i], "-x")) || (!strcmp(argv[i], "-f"))) &&
                ((!strcmp(argv[i + 1], "-x")) || (!strcmp(argv[i + 1], "-f"))))
            {
            printf("\nYou have %s %s\nYou need %s <expression(s)> %s\n",
                    argv[i], argv[i + 1], argv[i], argv[i + 1]);
            input_error();
            }

        if (type == NDEL_EXT)
            {
            strcpy(sav_file,"*.");
            strcat(sav_file, argv[i]);

            if (!strcmp(argv[i + 1], "-f"))
                {
                type = NDEL_FILE;
                i++;
                }
            }
        else
            {
            strcpy(sav_file, argv[i]);
            strcat(sav_file, ".*");

            if (!strcmp(argv[i + 1], "-x"))
                {
                type = NDEL_EXT;
                i++;
                }
            }

        /*  Scan through the directory structure, finding all matches,
            which are put in the save array                                 */

        done = findfirst(sav_file, &ffblk_st, 0);
        while (!done)
            {
            memset(sav_ar[index], '\0', NDEL_FILE_LEN);
            strcpy(sav_ar[index++], ffblk_st.ff_name);
            done = findnext(&ffblk_st);
            }
        }

    /* everything should be backed up, now let's delete all unwanted files  */

    strcpy(sav_file, "*.*");
    done = findfirst(sav_file, &ffblk_st,0);

    while (!done)
        {
        okay_to_del = NDEL_TRUE;
        for (i = 0; (i < index) && (i < NDEL_MAX_ENT); i++)
            {
            if (!strcmp(sav_ar[i], ffblk_st.ff_name))
                {
                okay_to_del = NDEL_FALSE;
                break;
                }
            }

        if (okay_to_del == NDEL_TRUE)
            {
            if (chmod(ffblk_st.ff_name, S_IREAD|S_IWRITE))
                perror("del: chmod");

            if (remove(ffblk_st.ff_name))
                perror("del: remove");
            }

        done = findnext(&ffblk_st);
        }
}
