;Ŀ
; BACKDROP.ASM                                              
;Ĵ
;                                                           
; This program displays a 'backdrop' for DESQview.  It is   
; similar to wall-paper type programs in X-Windows.         
; It displays the TIME, MEMORY STATUS, and a simple         
; logo showing the version of DESQview running.             
;                                                           
; NOTES: Take a look at the ORPHAN window data stream.      
; This stream ORPHANS the parent window.  The effect is to  
; remove it from the DESQview switch windows list.  It can  
; be added back to the switch windows list by sending any   
; manager stream commmand.                                  
;                                                           
; The program increases the logical and physical window     
; size to 60 x 80 to allow it to be 'full screen' in        
; 25,43,50, and 60 line modes.  If you have setup for       
; Hercules or Genius you will need to modify the init_strm  
; window data stream.  Refer to init_log and init_phys      
; in BACKDROP.DAT                                           
;                                                           
;Ĵ
; To create BACKDROP.ASM                                    
;                                                           
; > MASM BACKDROP;                                          
; > LINK BACKDROP;                                          
; > EXE2BIN BACKDROP.EXE BACKDROP.COM                       
;

            title backdrop
            page  60,132


code        segment
            assume cs:code,ds:code
            org   0100h

entry:      jmp   start

include     dvapi.inc                  ;API macro file
include     dvapi.mac                  ;My extensions
include     dvapi.equ                  ;  "     "
include     backdrop.dat

start:      mov   ax,cs                ;setup data segment
            mov   ds,ax

            @call dvpresent            ;check for DESqview
            test  ax,ax
            jz    eoj                  ;if not present, exit
            mov   ver,ax
            call  inits                ;get object handles and setup window

main:
            call  chk_mem
            call  set_time             ;display time
            jmp   main                 ;loop indefinitely

eoj:
            mov   ah,4ch
            int   21h

;Ŀ
; inits: get handles, display time, start timer             
;Ĵ
; input:                                                    
;  none                                                     
; output:                                                   
;  none                                                     
;

inits       proc  near
            @send new,timer
            @pop  tim
            @send handle,me
            @pop  win
            mov   ax,ver
            add   ah,'0'
            mov   logo_vers,ah
            xor   ah,ah
            mov   dx,ax
            mov   bx,offset logo_vers+2
            mov   cnvtcnt,2
            call  bin2dec
            @strm init_strm,win
            call  fill_screen
            @strm text_strm,win
            @strm logo_strm,win
init_orphan:
            @strm orphan,win
            ret
inits       endp

;Ŀ
; set_time: update the time display and reset timer         
;Ĵ
; input:                                                    
;  none                                                     
; output:                                                   
;  none                                                     
;

set_time    proc  near
            call  get_time             ;get current time
            call  get_date             ;get current date

            mov   si,offset updt_strm  ;send stream to update date and time
            mov   cx,updt_strml
            call  win_me

            mov   cx,100               ;1 second delay
            xor   dx,dx                ;clear high word
            @push dxcx                 ;push delay
            @send addto,tim            ;set timer
            ret
set_time    endp

;Ŀ
; get_time: get system time, format for display             
;Ĵ
; input:                                                    
;  none                                                     
; output:                                                   
;  none                                                     
;

get_time    proc  near
            mov   di,offset stime      ;output buffer
            mov   ah,2ch               ;get system time
            int   21h
            mov   al,ch
            call  unpack               ;display hour
            mov   al,cl
            call  unpack               ;display minutes
            mov   al,dh
            call  unpack               ;display seconds
            ret
get_time    endp

;Ŀ
; get_date: get system date, format for display             
;Ĵ
; input:                                                    
;  none                                                     
; output:                                                   
;  none                                                     
;

get_date    proc  near
            mov   di,offset sdate      ;output buffer
            mov   ah,2ah               ;get system date
            int   21h
            mov   al,dh
            call  unpack               ;write month
            mov   al,dl
            call  unpack               ;write day
            sub   cx,1900              ;subtract centuries
            cmp   cx,100               ;still > 100?
            jl    date_write           ;if not, write it
            sub   cx,100               ;else, subtract out for > 2000
date_write: mov   al,cl                ;get year
            call  unpack               ;write year
            ret
get_date    endp

;Ŀ
; unpack: unpack binary to 2 byte ascii decimal             
;Ĵ
; input:                                                    
;  al binary value to unpack                                
;  di pointer to output buffer                              
; output:                                                   
;  di incremented by 3                                      
;  ax destroyed                                             
;

unpack      proc  near
            aam                        ;divide al by 10.
            add   ax,3030h             ;convert digits to ascii.
            mov   [di],ah              ;write 10's digit
            inc   di                   ;next offset
            mov   [di],al              ;write units digit
            inc   di                   ;next offset
            inc   di                   ;skip past separator
            ret
unpack      endp

;Ŀ
; fill_screen: fill the screen with alternating box chars   
;

fill_screen proc  near

boxa        equ   176
boxb        equ   177
            cld
            mov   cx,4800
            @call shadow
            mov   ah,attr
            mov   al,boxa
            xor   dx,dx
fill_loop:
            stosw
            inc   dx
            cmp   dx,80
            jne   exchg
            xor   dx,dx
            jmp   loop_end
exchg:      cmp   al,boxa
            jne   get_boxa
            mov   al,boxb
            jmp   loop_end
get_boxa:   mov   al,boxa
loop_end:   loop  fill_loop
            ret
fill_screen endp

;Ŀ
; ckk_mem: check the various API memory calls               
;

chk_mem     proc  near
            @call commonmem
            mov   ax,offset com_strm+1
            call  write_mem
            @call convenmem
            mov   ax,offset con_strm
            call  write_mem
            @call expandmem
            mov   ax,offset exp_strm
            call  write_mem
            @strm mem_strm,win
            ret
chk_mem     endp

;Ŀ
; write_mem: write the values to the parent window          
;

write_mem   proc  near
            push  cx
            push  bx
            push  dx
            mov   bx,ax
            mov   cx,3
write_mem_loop:
            pop   dx
            mov   cnvtcnt,5
            call  bin2dec
            add   bx,4
            loop  write_mem_loop
            ret
write_mem   endp

;Ŀ
; bin2dec: convert 2 byte binary to ascii decimal           
;Ĵ
; input:                                                    
;   dx   value to convert                                   
;   bx   destination                                        
; output:                                                   
;   none                                                    
;

bin2dec     proc  near
            push  cx

            mov   ax,dx                ;save value
            mov   si,10                ;get divisor
            xor   cx,cx                ;zero out for counting digits
bin2dec_loop:
            xor   dx,dx                ;zero out
            div   si                   ;divide value by ten
            push  dx                   ;stack digits in reverse order
            inc   cx                   ;increment digit counter
            or    ax,ax                ;zero yet?
            jne   bin2dec_loop         ;if not, loop
            xor   dx,dx
bin2dec_pad:
            cmp   cx,cnvtcnt
            jge   bin2dec_begin        ;if yes, go write them
            push  dx                   ;push zero pad
            inc   cx                   ;increment digit count
            jmp   bin2dec_pad          ;loop
bin2dec_begin:
            xor   dx,dx
bin2dec_char:
            pop   ax                   ;pop digit
            cmp   dx,1
            je    bin2dec_add
            cmp   al,0
            jne   bin2dec_blankoff
            mov   al,' '
            jmp   bin2dec_write
bin2dec_blankoff:
            mov   dx,1
bin2dec_add:
            add   al,'0'               ;convert to ascii
bin2dec_write:
            mov   [bx],al
            inc   bx
            loop  bin2dec_char         ;loop till all char written

            pop   cx
            ret                        ;return
bin2dec     endp

include     win_me.inc
include     win_strm.inc

code        ends
            end   entry
