(****************************************************************
*
*  Name:          HELLO
*
*  Function:      display 'hello world' in the task window
*
*  Shows how to:  1. write a 'minimal' DESQview-specific program.
*                 2. initialize and disable the Pascal interfaces.
*                 3. detect DESQview's presence.
*                 4. enable DESQview extensions.
*                 5. write to the default task window.
*
****************************************************************)

program Hello;

uses DVAPI;

const

  (* minimum API version required *)
  REQUIRED = $201;

var

  (* actual API version *)
  version : integer;

  (* TFDD text file *)
  tfd : text;


(**********************************************************************
*  main  -  check for DESQview present and enable required extensions.
***********************************************************************)

begin

  (* initialize Pascal interfaces and get API version number *)
  version := api_init;

  (* if DESQview is not running or version is too low, display a message *)
  if (version < REQUIRED) then
    writeln ('This program requires DESQview version ',REQUIRED div 256,
       '.',(REQUIRED mod 256) div 16,(REQUIRED mod 256) mod 16,' or later.')

  (* tell DESQview what extensions to enable *)
  else
  begin

    (* set required API level *)
    api_level (REQUIRED);

    (* open TFDD and assign to window *)
    tfd_open (tfd,win_me);

    (* extend greetings *)
    writeln (tfd,'hello world');

    (* close TFDD *)
    tfd_close (tfd);

  end;

  (* disable Pascal interfaces and return from program *)
  api_exit;

end.
