/********************************************************************
**  YRCLMISC.C v0.17T  Copyright (c) 1987, 1988, 1989 by Paul M. Sittler.
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**************************************************************/

/* ANSI header files included:  */
#include <stdio.h>	/* fputs, printf, sprintf, stderr */
#include <ctype.h>	/* isdigit, tolower */
#include <fcntl.h>	/* O_BINARY, O_RDWR */
#include <io.h>		/* close, lseek, open, read, write */
#include <stdlib.h>	/* atoi, exit */
#include <string.h>	/* strcat, strcpy, strlen */

/* Turbo-C Header files included:  */
#include <conio.h>	/* getch, putch */

#include "yearcal.def"

extern struct options Opt;		/* Declared in YEARCAL.C */
extern FILE *fp;			/* Declared in YEARCAL.C */
extern char *file;			/* Declared in YEARCAL.C */
extern struct month mon[];		/* Declared in YEARCAL.C */
extern int yr[][12][6][7];		/* Array for 3 yrs, 4-D, */




char *center(char *str, int width)
{
    static char buf[BUF];		/* Location of finished string */
    static char copy[BUF];		/* Copy of str to avoid side effects */

	char filler;
    int i;

    filler = ' ';
    strcpy(copy, str);			/* Copy str to copy */

    if (strlen(copy) >= width)		/* Test for str longer than width */
	copy[width] = '\0';		/* Terminate it at width */

    strcpy(buf, char_str( (width - strlen(copy) ) >> 1, filler));
    strcat(buf, copy);
    i = strlen(buf);

    while (width - i)
	 buf[i++] = filler;

    buf[i] = '\0';

    return(buf);
}



char *trim(char *str)			/* Trim spaces from end of string */
{
    static char buf[BUF];		/* Location of finished string */
    char filler;
    int i;

    filler = ' ';
    strcpy(buf, str);
    i = strlen(buf);

    while (buf[--i] == filler)
	buf[i] = '\0';

    return(buf);
}



char *char_str(int length, char c)
{
    static char loc[BUF];
    char *ptr = loc;

    while (length--)
	*ptr++ = c;

    *ptr = '\0';

    return(loc);
}



int get_int(int defalt, int digits, int lowest, int highest)
/*  defalt,	default value when C/R alone is struck */
/*  digits,	maximum number of digits accepted */
/*  lowest,	lowest value accepted */
/*  highest;	highest value accepted */
{
    char buffer[80];			/* Buffer to store input string */
    int ch;				/* All purpose character ch */
    int index = 0;			/* Character array index */
    int value = 0;			/* Value to return */
    int done = FALSE;			/* Done/Not Done Flag */
    char dfalt[10];			/* Buffer to store default value */
					/* as string */
    int i, ii;				/* Length of default val as a string */

    sprintf(dfalt, "%d", defalt);	/* Convert default to string */
    i = ii = strlen(dfalt);		/* Calculate its length */
    printf("%s", dfalt);		/* Display default value */

    while (ii--)
	putch('\b');			/* Backspace to beginning */

    while (!done)
    {
	while (index < digits)  	/* While not enough digits, grab 'em */
	{
	    ch = getch();  		/* Get a char from console, no echo */

	    if (isdigit(ch))		/* Digit!! so . . .  */
	    {
		putch(ch);		/* Echo it to console, and */
		buffer[index++] = ch;	/* Stuff it into buffer */

		if (index == 1)	 	/* Entered first digit, so. . . */
		{
		    for (ii = digits;
			 --ii;
			     )
			putch(' ');	/* Blank it out */

		    for (ii = digits;
			 --ii;
			     )
			putch('\b');	/* Backspace to beginning */
		}
	    }

	    else
	    if ( ch == '\b' && 		/* Backspace? */
		 index       )		/* if index not zero */
	    {
		--index;		/* Reduce index */
		putch(' ');		/* Blank it */
		putch('\b');		/* Backspace over blank */
		putch(ch);		/* Echo it to console */
	    }

	    else
	    if (ch == '\033')		/* Escape */
		exit(0);		/* says he's through */
	    else
	    if (ch == '\r')		/* Return? */
		break;			/* says he's through */
	}	/* End while not enough digits, grab 'em */

	buffer[index] = '\0';		/* Terminate string */

	if (index == 0)			/* No digits entered before return */
	{
	    value = defalt;		/* So use default */
	    done  = TRUE;		/* We're through */
	}
	else				/* Some digits were entered */
	{
	    value = atoi(buffer);	/* Convert string to integer */

	    if (value < lowest ||	/* Range test value returned */
		value > highest )
	    {				/* Out of allowable range. . . */
		for (	    ;
		       index;
		     --index )
		    putch('\b');	/* Backspace to beginning */

		for (ii = digits;
		     ii;
		     --ii)
		    putch(' ');		/* Blank it out */

		for (ii = digits;
		     ii;
		     --ii)
		    putch('\b');	/* Backspace to beginning */

		printf("%s", dfalt);    /* Display default value */

		for (ii = i;
		     ii;
		      --ii)
		    putch('\b');	/* Backspace to beginning */
	    }
	    else
	    done  = TRUE;		/* We're through */
	}
    }		/* end while !done */
    return(value);
}



int get_yn(char defalt)
{
    char c;				/* all purpose character */

    fputs(" (y/n) ? ", stderr); 	/* Prompt for Yes or No */
    putch(defalt);			/* Display default */
    putch('\b');			/* Backspace to it */

    do
	c = tolower(getch());		/* Get a char, make it lowercase */
	while ( c != 'y'    &&		/* Until we get a y, n, ESC, */
		c != 'n'    &&
		c != '\033' &&
		c != '\r'    );		/* or Return */

    if (c == '\033')			/* Escape */
	exit(0);			/* says he's through */
    else
    if (c == '\r')			/* If a return, make it the default */
	c = defalt;

    putch(c);				/* Display choice to user */

    return (c == 'y') ?
		 TRUE :
		FALSE  ;
}



void hold(void)
{
    fputs("\nPrinter ready?  Any key to continue. . . ", stderr);
    getch();
}



void signon(void)
{
    fprintf(stderr,
"\t\t\tYEARCAL v0.17T %s @ %s\n\n", __DATE__, __TIME__);
    fputs(
"\t\tCopyright 1987, 1988, 1989 by Paul M. Sittler\n\n"

"\tYEARCAL makes calendars (A/M) or schedules (W/D) for years after 1582.\n\n"

"\tAt the user's option, Normal, Fiscal Year, AGGIE, or 3-Digit Julian\n"
"\tDate Calendars can be produced, in multiple copies, for a number of\n"
"\tconsecutive years, or both.  Fiscal Year calendars may be produced for\n"
"\tany arbitrary 12 or 13 month fiscal year.  The user may select a\n"
"\tProgrammer's calendar, numbered in Hexadecimal or Octal numbers rather\n"
"\tthan decimal numbers, and may choose one of several languages.\n\n"
"\tThe calendars may be displayed on the screen, printed, or written to\n"
"\ta file as desired.  If written to disk, files are named like YYYY.ENG\n"
"\t(Normal ENGlish), YYYYFY.DUT (Fiscal-Year DUTch), YYYYAGG.TEX (Aggie-\n"
"\ttype TEXan), or YYYYJUL.POL (3-Digit Julian Date POLish) calendars,\n"
"\tetc.  Hex or Octal calendar files will have an \"H\" or \"O\" added to\n"
"\ttheir names, such as YYYYH.SPA, YYYYFYO.SER or YYYYAGGH.FRE.\n\n"

"\tYEARCAL may be freely distributed, and used for non-commercial\n"
"\tpurposes, as long as the unmodified program source code and\n"
"\tdocumentation files are distributed with it.\n", stderr);
}



void setup_files(char out)
{
    if (fp)
	fflush(fp);

    if (out == 'V')
    {
	if (!strcmp(file, "PRN"))
	    fclose(fp);

	if (strcmp(file, "CON"))
	{
	    strcpy(file, "CON");
	    fp = fopen(file, "w");
	}
    }
    else
    if (out == 'P')
    {
	if (!strcmp(file, "CON"))
	    fclose(fp);

	if (strcmp(file, "PRN"))
	{
	    strcpy(file, "PRN");
	    fp = fopen(file, "w");
	}
    }
}



/************************************************************************/
void get_opts(char *name)
/* char *name	filename from argv[0] */
{
	/* Various statistics (such as the last time the program was run)
	* are stored in a buffer at the end of the executable structure.
	* These stats and the settings for user selected options are all
	* stored in the "options" structure.  This function creates the
	* data area if it doesn't exist and initializes Opt as appropriate.
	* Alan Holub, C-Chest, DDJ Feb 1988.
	*/

    int fd;				/* file descriptor handle */
    int i, *p;				/* used to create checksum */

    if ( (fd = open( name, O_RDWR | O_BINARY ) ) == ERROR)
    {
	perror( name);
	exit(1);
    }

    lseek(fd, 0L - sizeof(Opt), SEEK_END);

    /* Check to see if all of the options area is still there */
    if ( read(fd, (char *) &Opt, sizeof(Opt) ) != sizeof(Opt) )
	ferr( "Internal error:  Can't read options\n");

    /* Check to see if the signature is still as it should be */
    if (strcmp( DEF_SIG, Opt.signature) != 0)
    {
	memset( &Opt, 0, sizeof(Opt));
	/* The memset is for debugging.  It shows us that the record has
	 * been written correctly.
	 */

	strcpy( Opt.signature, DEF_SIG);

        /* Initialize other fields in the Opt structure here. */
    	Opt.aggie	= FALSE;	/* Not all are Aggies! */
	Opt.bh		=  6;		/* Hour defaults to 0600 */
	Opt.copies	=  1;		/* At least one copy. . . */
	Opt.fy		= FALSE;	/* Most are not Fiscal Year */
	Opt.indent      =  7;		/* Left Margin Indent in spaces */
	Opt.julian	= FALSE;	/* Regular calendar is default */
	Opt.lang	=  7;		/* Select English as default Language */
	Opt.lds		=  0;		/* Select ASCII for line drawing Set */
	Opt.more_yrs	=  0;		/* One period at a time. . . */
	Opt.nh		= 24;		/* Scheduled Hour defaults to 24 */
	Opt.pause	= FALSE;	/* No pause at end of each printed page */
	Opt.mil		= TRUE;		/* Military (24-hour) time */
	Opt.pl		= 66;		/* Page Length in lines */
	Opt.pw		= 80;		/* Page Width in characters or columns */
	Opt.base	= FALSE;	/* Decimal for most */
	Opt.sched_type 	= FALSE;	/* Annual calendar is default */

	for (i = 0;			/* Initialize title array */
             i < 8;
             i++)
	    Opt.title[i][0] = '\0';

	Opt.chksum = 0;

        for (p = (int *)(&Opt), i = sizeof(Opt) / 2;
             --i >= 0;
		      )
            Opt.chksum -= *p++;

        lseek(fd, 0L, SEEK_END);

	if (write(fd, (char *) &Opt, sizeof(Opt)) != sizeof(Opt) )
	    ferr("Internal error:  Can't initialize options\n");
    }
    close(fd);
}



void put_opts(char *name)
{
    /* Update the options buffer at the end of the .EXE program (which
     * better exist).  If the options buffer doesn't exist, this function
     * will destroy the end of the file.  Alan Holub, C-Chest, DDJ Feb 1988.
     */

    int fd;				/* file descriptor handle */
    int i, *p, checksum;		/* used to create checksum */

    if ( (fd = open( name, O_RDWR | O_BINARY) ) == -1)
    {
	perror( name );
	exit(1);
    }

    /* Recompute the checksum */

    checksum = 0;

    for (p = (int *)(&Opt), i = sizeof(Opt) / 2;
       --i >= 0;
		  )
	checksum -= *p++;

    if (checksum != Opt.chksum)
	printf("\tDefaults have been changed.");

    Opt.chksum = checksum;

    lseek(fd, 0L - sizeof(Opt), SEEK_END);

    if (write(fd, (char *) &Opt, sizeof(Opt)) != sizeof(Opt) )
	ferr("Can't do final options update\n");

    close(fd);
}



void ferr(char *fmt)
{
    /* ferr() is used for fatal error processing.  It is used just like
     * printf().  However, it exits the program with a status of 1
     * immediately after printing the message.  I'm using ANSI, not UNIX
     * variable argument conventions here.  (Alan Holub, C-Chest Book, p. 299)
     */

    va_list args;
    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    exit(1);
}



void prep_cal(int year)
{
    int count,				/* Count of the days */
	day,				/* Weekday Sun=0, Mon=2, ... Sat=6 */
	month,				/* Month Jan=0, Feb=1, ... Dec=11 */
	week,				/* Six weeks/month possible */
	yeer,				/* Year for calendar */
	y;				/* Year Last=0, This=1, Next=2 */

    for (y = 0;				/* Start at last year y[0] */
	 y < 3;				/* Stop after next year y[2] */
	 y++)
    {
	yeer = (year + y - 1);

	if (leap(yeer))			/* Tidy up month length array */
	    mon[1].length = 29; 	/* For this year by fixin' Feb. . . */
	else
	    mon[1].length = 28;

	/* Get weekday of first day of each month, put into array mon */
	/*   Jan = 0, Feb = 1, Mar = 2, Apr = 3, . . .  Dec = 11 */
	/*   Su = 0, Mo = 1, Tu = 2, We = 3, Th = 4, Fr = 5, Sa = 6 */
	for (month =  0;
	     month < 12;		/* 12 months/year */
	     month++   )
	    mon[month].first_day = weekday(yeer, month + 1, 1);

	/* Form year array with 0 for unused dates, with dates */
	/*   in their relative positions by weekday */
	for (month = 0;
	     month < 12;		/* 12 months/year */
	     month++)
	{
	    count = 0;			/* Set day counter to 0 */

	    for (week = 0;
		 week < 6;		/* 6 weeks/month */
		 week++)
	    {
		for (day = 0;
		     day < 7;		/* 7 days/week */
		     day++)
		{
		    if (week == 0                 &&	/* 1st week of month */
			day < mon[month].first_day )    /* Before 1st day */
			yr[y][month][week][day] = 0;	/* Zero it */
		    else
		    if (++count <= mon[month].length)   /* Not past EOMonth */
			yr[y][month][week][day] = count;
		    else
			yr[y][month][week][day] = 0;	/* Zero it */
		}
	    }
	}
    }
}



/* Function to get day of week from YYYY, MM, DD as integers */
/* This uses the Zeller Congruence algorithm, as shown in:  */
/*   Radcliffe, Robert A. & Raab, Thomas J., "Data Handling Utilities in C", */
/*   1986, SYBEX Books, 2344 Sixth Street, Berkeley, CA 94710. */
/* Explanation of algorithm is in:  Uspensky & Heaslet, */
/*   "Elementary Number Theory", Appendix A:  Calendar Problems */
/* Discussion of Zeller Congruence in: */
/*  "Day of the Week Revisited", Computer Language, Dec 1988, pp 35-38. */
/* Discussion also in Computer Languages Magazine, Feb 1989, p 9 in a */
/*   letter from Bob Whitefield. */
/* For MM:  Jan = 1, Feb = 2, Mar = 3, Apr = 4, . . .  Dec = 12 */
int weekday(int YYYY, int MM, int DD)
{
    int day_of_week,			/* Su = 0, Mo = 1, . . . Sa = 6 */
	y,              		/* Year adj for Zeller congruence */
	m,				/* Month adj for Zeller congruence */
	dy,				/* Decimal year, 2-digits like '89 */
	c;				/* Century 2-digits, like 19xx */

    if (MM > 2)				/* After February, so decrement */
    {
	m = MM - 2;			/* Run year from March to February */
	y = YYYY;			/* Keep YYYY value same */
    }
    else				/* Month is January or February */
    {
	m = MM + 10;			/* Make them the 11th and 12th */
					/*   months respectively */
	y = YYYY - 1;			/* So we have one less year */
    }

    c  = y / 100;			/* Get century number */
    dy = y - (100 * c);			/* Decimal year */
    day_of_week = ( (13 * m - 1) / 5)
		  + DD + dy + (dy / 4)
		  + (c / 4) - c - c + 77;
    day_of_week = day_of_week - 7 * (day_of_week / 7);

    return(day_of_week);
}



/* Function to decide if a year is a leap year */
int leap(int years)
{					/* Leap year sieve */
    if (years & 0x0003) 		/* Mask year to see if not leap year */
       return FALSE;    		/* If we look at the last two bits,  */
					/* and one of them is on, then the   */
					/* year can't be divisible by four.  */
					/* Thus it is not a leap year, so    */
					/* function returns FALSE.           */
					/* Test for the leap century.        */
    else				/* Leap century:   years that are:   */
    if (!(years % 100) && 		/* evenly divisible by 100:          */
					/*   not leap years unless also      */
	 (years % 400) )		/*   evenly divisible by 400.        */
	return FALSE;			/* Gruenberger and Jaffray,          */
					/* "Problems for Computer Solution", */
					/* Wiley, 1965. */
					/* We have filtered out all years    */
					/* that are not evenly divisible by  */
					/* four as well as those evenly      */
					/* divisible by 100 that are evenly  */
					/* divisible by 400. */
					/* It seems that all the rest are    */
					/*   (a) evenly divisible by four    */
					/*   (b) evenly divisible by 400     */
    return TRUE;			/*   (c) Thus, leap years. . . */
}



