NAME
	event - full-screen interactive data entry for events reminder

SYNOPSIS
	event [file...]

DESCRIPTION
	Event is a program to help create entries in the user's
DATES file for use by reminder, which keeps track of things as
appointments, scheduled travel, etc.  When the program is
invoked, event pops up an edit window.  Full cursor movement
between fields is supported, using Left, Right, Up, Down,
Control-Left, Control-Right, Home, End, Enter.  Insert toggles
insert mode.  Control-T erases from the cursor to the end of the
current field; Control-Y erases from the cursor to the end of
the window.  ESC aborts.

Unlike remind, from which it is derived, which will run on any
MS-DOS machine, event will run only on a true PC-compatible.

Event leaves the screen undisturbed: it pops up, and restores
the obscured area on exit.  This is intended for applications
like the following batch file:

	echo off
	cls
	cal
	event

where cal is like the *nix utility of the same name (which shows
the current month's calendar when called w/o parms).  This batch
file leaves the calendar visible while the user is in event.

Another application is to use event from inside an editor while
editing the reminders file.  Assuming your dates files is
c:\dates, the following Jove macro loads the dates file if it
is not already loaded, switches to it, runs event to add a new
reminder, and then refreshes the screen display of the dates
file to reflect the new reminder:

define-macro reminder-add-event ^[xfind-file c:\dates^M^[xsave-file^M
   ^[xshell-command event c:\dates^M^[xselect-buffer dates^M
   ^[xdelete-other-windows^M^[xvisit-file ^M^[xend-of-file^M

This should be put in your Jove.rc file, all on one line.  The
following can also be put there to bind this macro to the
key sequence Control-X Control-R:

bind-macro-to-key reminder-add-event ^X^R

With these done, typing the sequence Control-X Control-R pops
up event to add a new reminder; when event is done you are left
in a full-screen window editing the dates file.

Event's popup window contains the following fields:

Event:
  User types in the event, such as "workplace automation
meeting."

Time:
  User types in time of the event, using four-digit military time
such as 1300.  If the time is not applicable, just hit <CR>.

Date:
  Here the user types in the date of the event.  This could
either be a month and day such as "08/07", a full date such as
"10/06/86", a single day of the month (every month) such as "25",
a day of the week (string beginning with one of: "mo", "tu",
"we", "th", "fr", "sa", or "su", upper or lower case).

Days notice:
  User types in a number, which is the number of days before the
event that reminder will start displaying a reminder of the
event.  A <CR> alone will be interpreted as "0"; i.e.  reminders
will only be displayed on the day of the event.

Event then formats the input data as a one-line entry
in the user's DATES file for later use by reminder.
If a file is specified, the entry is put into this file,
instead of DATES.

FILES
	.\DATES

SEE ALSO
	REMINDER.MAN, REMIND.MAN

AUTHOR
	Derived from remind.c by Kenneth Van Camp <kvancamp@ardec>,
based on a shell script by Glenn Randers-Pehrson.
	Full-screen data entry by Richard Reiner
<rreiner@vm1.yorku.ca> or <grad3077@writer.yorku.ca>, using CXL
v5.0 by Mike Smedley.