#ifndef __GRAFMESS_H
#define __GRAFMESS_H

#include "gui.h"
#include <graphics.h>
#include "vector.h"
#include "data.h"


/* IMPORTANT!

	At some point a person may need to change the inline copying of
	the mouse to an external copy in the constructor.  So instead
	of the_mouse (mouse) where Mcursor & the_mouse in the header file,
	may need to be Mcursor the_mouse in the header and in the constructor
	the_mouse = mouse. */

class grafmess
	{
	public:
		grafmess (Mcursor & mouse);
		~grafmess ();

		void no_match (); /* tells the user no match was found in
					a search */

		int edit_graphics (int how_many);
//		^^ returns either -1 for exit, or the # to edit!

		int remove_graphics (int how_many);
//		^^ returns either -1 for exit, or the # to delete!

//		void init (Mcursor & mouse);

		void show_panels_set (int m, int d, int y);
		/* above must be called before show_panels */
		void show_panels (int panel_num, data the_data, int calendar_mode = 0);
		// if it is set to > 1 it does not show warning information

		int num_buttons (int how_many);
		/* Function returns:
			-1 if exit was pressed
			1-5 if it wasn't
		*/

		int bottom_buttons (int more, int noupdate = 0);
		/* Current is the current # you are on.  So if
			   you are showing panels 0-4 current = 0

			Function returns:
				1 if exit was pressed
				2 if edit was pressed
				3 if delete was pressed
				4 if save & exit was pressed
				5 if more was pressed
				6 if back a page was pressed
				7 if help was requested

		Set noupdate = 1 if you don't want the exit & update
		option available.
			*/


	private:

		void write3d (int y,char *text);

		int month, day, year;
		void gr_clear (void);
		void clear_bottom ();

		vector<Button>	buttons;
		Mcursor		& the_mouse;
	};

#endif /* __GRAFMESS_H */
