//======================================================================

//  File:        bstring.cpp

//  Author:      Timothy A. Budd

//  Description: This file contains the implementation of the

//               bstring class.

//

//  Copyright (c) 1992 by Timothy A. Budd.  All Rights Reserved.

//======================================================================

 

#include <assert.h>			// assertions

#include "bstring.h"			// bstring class

 

 

 

//----------------------------------------------------------------------

//	calculate length of a C bstring

//----------------------------------------------------------------------

 

int CbstringLength(const char * str)

{

    // compute number of non-null characters in a C bstring

    int i = 0;

 

    while (str[i] != '\0')

	i++;

 

    return i;

}

 

 

 

//----------------------------------------------------------------------

//	class bstring implementation

//----------------------------------------------------------------------

 

bstring::bstring()

{

    // create a bstring with no characters

    // length is one, holding just null character

    // allocate the new buffer

    bufferlength = 1;

 

    // initialize buffer with null character

    buffer = new char[bufferlength];

    assert(buffer != 0);

 

    // initialize to null

    buffer[0] = '\0';

}

 

 

 

bstring::bstring(char c)

{

    // create a bstring with a single character

    bufferlength = 2;

    buffer = new char[bufferlength];

    assert(buffer != 0);

 

    // initialize with single character

    buffer[0] = c;

    buffer[1] = '\0';

}

 

 

 

bstring::bstring(int size)

{

    // create a new bstring with a buffer of the given size

    // make sure size is positive

    assert(size >= 0);

 

    // hold one addition char for null value

    bufferlength = 1 + size;

 

    // allocate buffer, check allocation was successful

    buffer = new char[bufferlength];

    assert(buffer != 0);

 

    // initialize to all null characters

    for (int i = 0; i < bufferlength; i++)

	buffer[i] = '\0';

}

 

 

 

bstring::bstring(const char * initialtext)

{

    // create a new bstring and initialize with argument value

    // length is length of text, plus null char

    bufferlength = 1 + CbstringLength(initialtext);

 

    // allocate buffer

    buffer = new char[bufferlength];

    assert(buffer != 0);

 

    // copy values into place

    for (int i = 0; initialtext[i] != '\0';  i++)

	buffer[i] = initialtext[i];

 

    buffer[i] = '\0';

}

 

 

 

bstring::bstring(const bstring & initialbstring)

{

    // create a new bstring, initializing with copy of argument

    // length is length of text, plus null char

    bufferlength = 1 + CbstringLength(initialbstring.buffer);

 

    // allocate buffer

    buffer = new char[bufferlength];

    assert(buffer != 0);

 

    // copy values into place

    for (int i = 0; initialbstring.buffer[i] != '\0'; i++)

	buffer[i] = initialbstring.buffer[i];

 

    buffer[i] = '\0';

}

 

 

 

bstring::~bstring()

{

    // called implicitly when a bstring is about to be deleted

    // free the memory associated with the buffer

    delete [] buffer;

 

    // set the pointer variable to null

    buffer = 0;

}


char *	bstring::return_string () const
	{
	return buffer;
	}

// the following were implemented by jeff goke for cs200 lab3

 

int bstring::num_letters() const

	{

	int letters = 0;

	int i = 0;



	while (buffer[i] != '\0')

		{

		if (((buffer[i] > 'a')&&(buffer[i] < 'z'))||
			((buffer[i] > 'A')&&(buffer[i] < 'Z')))
			letters++;
		i++;

		}



	return i;

	}

 

int bstring::num_words() const

	{

	int i = 0;
	int words = 0;


	while (buffer[i] != '\0')

		{

		if (buffer[i] == ' ')
		      words++;

		i++;

		}



	return words;

	}



int bstring::ave_words() const

	{

	int words = num_words();

	int letters = num_letters();



	return (letters/words);

	}



// end of implementations by jeff goke

 

void bstring::operator = (const bstring & right)

{

    // copy values of right argument into bstring

    const int rightLength = right.length();

 

    // if it doesn't fit, make a new buffer

    if (rightLength >= bufferlength)

    {

	// delete current buffer

	delete [] buffer;

 

	// allocate the new one

	bufferlength = 1 + rightLength;

	buffer = new char[bufferlength];

	assert(buffer != 0);

    }

 

    // copy into buffer

    for (int i = 0; right.buffer[i] != '\0'; i++)

	buffer[i] = right.buffer[i];

 

    buffer[i] = '\0';

}

 

 

 

void bstring::operator += (const bstring & val)

{

    // append argument to end of current bstring
    // if there isn't space, make new buffer

    int combinedLength = length() + val.length();
    char * newbuffer = 0;
 

    if (combinedLength >= bufferlength)

    {

	newbuffer = new char [1 + combinedLength];

	assert(newbuffer != 0);

 	bufferlength = 1 + combinedLength;
     }

     else
	newbuffer = buffer;

	// copy over old values

	for (int i = 0; buffer[i] != '\0'; i++)

	    newbuffer[i] = buffer[i];

 

	newbuffer[i] = '\0';


    // catenate val on end of current bstring

    i = CbstringLength(buffer);

 

    for (int j = 0; val.buffer[j] != '\0'; j++)

	newbuffer[i++] = val.buffer[j];

 

    newbuffer[i] = '\0';

    if (newbuffer != buffer)
	delete [] buffer;
    buffer = newbuffer;

}

 

 

 

subbstring bstring::operator ()(unsigned int index, unsigned int count)

{

    // return subbstring consisting of count chars starting at index

 

    // if index out of range return empty bstring

    if (index >= length())

    {

	index = 0;

	count = 0;

    }

 

    // convert count, if necessary

    int numberleft = length() - index;

 

    if (count > numberleft)

	count = numberleft;

 

    // make the new bstring, use this to be base bstring

    return subbstring(*this, index, count);

}

 

 

 

istream & bstring::getline(istream & in)

{

    // read an entire line of input into bstring

    in.getline(buffer, bufferlength, '\n');

    return in;

}

 

 

 

unsigned int bstring::length() const

{

    // compute the number of nonull characters in a bstring

    return CbstringLength(buffer);

}

 

 

 

char nothing;	// global variable holding null character

 

char & bstring::operator [](unsigned int index) const

{

    // return the character referenced by the index value

 

    // first see if the index is in bounds

    if (index >= CbstringLength(buffer))

    {

	// not in bounds, return null character

	nothing = '\0';

	return nothing;

    }

 

    // otherwise it is a valid index, return character

    return buffer[index];

}

 

 

 

int bstring::compare(const bstring & val) const

{

    // compare the buffer to the argument bstring value

    char * p = buffer;

    char * q = val.buffer;

 

    // loop as long as both have characters and are equal

    while ((*p != '\0') && (*p == *q))

    {

	// inv: up to *p buffer and val are equal

	p++; q++;

    }

 

    // by subtracting the values referred to by the pointers,

    // we yield a negative value if the first bstring is smaller

    // than the second, a zero value if they are equal,

    // and a positive value if the first is larger than the second

    return *p - *q;

}

 

 

 

bstring::operator const char *() const

{

    // convert bstring value into char pointer value,

    // by returning access to the underlying C buffer

    return buffer;

}

 

 

 

//----------------------------------------------------------------------

//	relational operators

//----------------------------------------------------------------------

 

int operator <  (const bstring & left, const bstring & right)

{ return left.compare(right) < 0; }

 

 

int operator <= (const bstring & left, const bstring & right)

{ return left.compare(right) <= 0; }

 

 

int operator != (const bstring & left, const bstring & right)

{ return left.compare(right) != 0; }

 

 

int operator == (const bstring & left, const bstring & right)

{ return left.compare(right) == 0; }

 

 

int operator >= (const bstring & left, const bstring & right)

{ return left.compare(right) >= 0; }

 

 

int operator >  (const bstring & left, const bstring & right)

{ return left.compare(right) > 0; }

 

 

 

//----------------------------------------------------------------------

//	function: concatenate operator

//----------------------------------------------------------------------

 

bstring operator + (const bstring & left, const bstring & right)

{

    // concatenate two bstrings, leaving  arguments unchanged

    bstring result(left);

    result += right;

    return result;

}

 

 

 

//----------------------------------------------------------------------

//	functions: character classification

//----------------------------------------------------------------------

 

int isUpperCase(char c)

{

    // return true if c is an upper case letter

    return (c >= 'A') && (c <= 'Z');

}

 

 

 

int isLowerCase(char c)

{

    // return true if c is a lower case letter

    return (c >= 'a') && (c <= 'z');

}

 

 

 

//----------------------------------------------------------------------

//	functions: bstring conversions

//----------------------------------------------------------------------

 

void toUpper(bstring & word)

{

    // convert all lower case letters to upper case

    for (int i = 0; word[i] != '\0'; i++)

	if (isLowerCase(word[i]))

            word[i] = (word[i] - 'a') + 'A'; 

}

 

 

 

void toLower(bstring & word)

{

    // convert all upper case letters to lower case

    for (int i = 0; word[i] != '\0'; i++)

	if (isUpperCase(word[i]))

            word[i] = (word[i] - 'A') + 'a'; 

}

 

 

 

//----------------------------------------------------------------------

//	function: stream input for bstring

//----------------------------------------------------------------------

 

istream & operator >> (istream & in, bstring & str)

{

    // perform bstring input,

    // read next white-space separated word into bstring

    // implemented using existing character input facility

    char inbuffer[1000];

 

    if (in >> inbuffer)

	str = inbuffer;

    else

	str = "";

 

    return in;

}

 

 

 

//----------------------------------------------------------------------

//	class subbstring implementation

//----------------------------------------------------------------------

 

subbstring::subbstring(bstring & b, int i, int c)

    : base(b), index(i), count(c)

{

    // create and initialize a subbstring value

    // no further initialization required

}

 

 

 

subbstring::subbstring(const subbstring & source)

    : base(source.base), index(source.index), count(source.count)

{

    // create and initialize a subbstring value

    // no further initialization required

}

 

 

 

void subbstring::operator = (const bstring & rep) const

{

    // copy a bstring value to a subbstring position

    // if lengths are equal, then no new allocation necessary

    if (count == rep.length())

    {

	for (int i = 0; i <= count; i++)

	    base[index + i] = rep[i];

 

	return;

    }

 

    // otherwise compute the length of the new bstring

    int baselen = base.length();

    int newlen  = rep.length() + baselen - count;

    char * newdata = new char[newlen + 1];

 

    // then copy the values into the new area

    for (int i = 0; i < index; i++)

	newdata[i] = base[i];

 

    // catenate on the new values

    for (int j = 0; rep[j] != 0; j++)

	newdata[i++] = rep[j];

 

    // then catenate on the base

    for (j = index + count; base[j] != 0; j++)

	newdata[i++] = base[j];

 

    newdata[i] = '\0';

 

    // then change the base bstring

    delete [] base.buffer;

    base.bufferlength = newlen;

    base.buffer = newdata;

 

    return;

}

 

 

 

subbstring::operator bstring () const

{

    // convert a subbstring into a bstring

    // first copy the text into a temporary buffer

    char * buffer = new char[count + 1];

    assert(buffer != 0);

 

    for (int i = 0; i < count; i++)

	buffer[i] = base[i + index];

 

    buffer[count] = '\0';

 

    // then make it into a bstring, and delete the buffer

    bstring result(buffer);

    delete [] buffer;

    return result;

}

