/*ͻ*\
   Filename:  FILE\ADD.CPP                   
   Name:      John Wiggins                   
   Course:    Programming II                 
   Function:  Creates a new data struct then 
              adds it to the linked list.    
\*ͼ*/
#include <graphics.h>
#include <stdlib.h>
#include "medusa.h"
#include "msi_wndw.h"
#include "mous.h"   // includes dos.h
#include "windw.h"  // includes string.h & event.h

void AddData(ProgramPtr &ProgramHead)
{
  // Make a new record to be placed in linked list later.
  ProgramPtr TempAdd, Tail;
  Tail = ProgramHead;
  // Get a new chunck of memory.
  TempAdd = new program_info;
  while (Tail->next != NULL)
    Tail = Tail->next;
  // Make the new windows for the elements of the struct.
  ItemWindw  *ProgNameWnd,  *PubNameWnd,  *CompTypeWnd,
             *ProgTypeWnd,  *VersionWnd,  *CopyRightWnd,  *CostWnd;
  char TempBuf[20], WndTitle[20];
  // Hide the mouse so user won't be tempted to use it.
  mouse.HideMouse();
  strcpy(WndTitle, "Add new data");
  // Create the first window and prompt user on how to exit.
  ProgNameWnd = new ItemWindw(WndTitle, "Program Name:",
                              "Example: Windows");
  ProgNameWnd->DrawWindow();
  ProgNameWnd->RunWindow();
  ProgNameWnd->GetInput(TempBuf);
  strncpy(TempAdd->Title, TempBuf, TITLE_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->Title[strlen(TempBuf)+1] = '\0';
  delete ProgNameWnd;

  // Publishers name \\
  PubNameWnd = new ItemWindw(WndTitle, "Publisher Name:",
			     "Example: Microsoft");
  PubNameWnd->DrawWindow();
  PubNameWnd->RunWindow();
  PubNameWnd->GetInput(TempBuf);
  strncpy(TempAdd->PublisherName, TempBuf, PUBLISHER_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->PublisherName[strlen(TempBuf)+1] = '\0';
  delete PubNameWnd;

  // Computer Type \\
  CompTypeWnd = new ItemWindw(WndTitle, "Computer Type:", "Example: IBM");
  CompTypeWnd->DrawWindow();
  CompTypeWnd->RunWindow();
  CompTypeWnd->GetInput(TempBuf);
  strncpy(TempAdd->ComputerType, TempBuf, COMPUTER_TYPE_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->ComputerType[strlen(TempBuf)+1] = '\0';
  delete CompTypeWnd;

  // Disk Type \\
  char WhatMedia=MediaButtons(WndTitle);
  switch(WhatMedia)
  {
    case 'A': strcpy(TempAdd->DiskType, "3.5 HD"); break;
    case 'B': strcpy(TempAdd->DiskType, "3.5 DD"); break;
    case 'C': strcpy(TempAdd->DiskType, "5.25 HD"); break;
    case 'D': strcpy(TempAdd->DiskType, "5.25 DD"); break;
    case 'E': strcpy(TempAdd->DiskType, "CD-ROM"); break;
    case 'F': strcpy(TempAdd->DiskType, "Hard Drive"); break;
  }
  mouse.HideMouse();
  // Program Type \\
  ProgTypeWnd = new ItemWindw(WndTitle, "Program Type:",
			      "Example: Operating System");
  ProgTypeWnd->DrawWindow();
  ProgTypeWnd->RunWindow();
  ProgTypeWnd->GetInput(TempBuf);
  strncpy(TempAdd->ProgramType, TempBuf, PROGRAM_TYPE_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->ProgramType[strlen(TempBuf)+1] = '\0';
  delete ProgTypeWnd;

  // Version \\
  VersionWnd = new ItemWindw(WndTitle, "Version:", "Example: 3.11");
  VersionWnd->DrawWindow();
  VersionWnd->RunWindow();
  VersionWnd->GetInput(TempBuf);
  strncpy(TempAdd->Version, TempBuf, VERSION_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->Version[strlen(TempBuf)+1] = '\0';
  delete VersionWnd;

  // Copyright \\
  CopyRightWnd = new ItemWindw(WndTitle, "Copyright Year:", "Example: 1993");
  CopyRightWnd->DrawWindow();
  CopyRightWnd->RunWindow();
  CopyRightWnd->GetInput(TempBuf);
  strncpy(TempAdd->Copyright, TempBuf, COPYRIGHT_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->Copyright[strlen(TempBuf)+1] = '\0';
  delete CopyRightWnd;

  // Program Cost \\
  CostWnd = new ItemWindw(WndTitle, "Cost of Program:", "Example: 107.25");
  CostWnd->DrawWindow();
  CostWnd->RunWindow();
  CostWnd->GetInput(TempBuf);
  strncpy(TempAdd->Cost, TempBuf, COST_LENGTH);
  // I found out that strncpy doesn't add the null character at the end,
  // so I will.
  TempAdd->Cost[strlen(TempBuf)+1] = '\0';
  delete CostWnd;
  mouse.ShowMouse();

  // Add TempAdd to the end (Tail) of the linked list.
  TempAdd->next = Tail->next;
  TempAdd->prev = Tail;
  Tail->next = TempAdd;
  Tail = Tail->next;
}