#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "extern.h"
#include "errors.h"
#include "types.h"

extern char modname[];

LIST *unresolvedexterns;

EXTERN **externtable;

static LIST **unresextptr;
static int newextid = 0;

BOOL ExternError(void)
{
	if (unresolvedexterns) {
		LIST *q = unresolvedexterns;
		while(q) {
			EXTERN *p = q->data;
			Error("Undefined external '%s' in module %s",p->name,p->modname);
			q = q->link;
		}
		return(TRUE);
	}
	return(FALSE);
}
		
void ExternDefinitions(int mode)
{
	char buf[MAX_NAMESIZE + 1];
	int id;
	EXTERN *ext;
	id = ReadNumber(0);
	if (id >= MAX_EXTERNS)
		fatal("Extern table full in module %s", modname);
  CheckForComma(TRUE);
  ReadString(buf,MAX_NAMESIZE+1);
	CheckForPeriod();
	ext = AllocateMemory(sizeof(EXTERN));
	ext->name = AllocateMemory(strlen(buf)+1);
	strcpy(ext->name, buf);
	ext->modname = AllocateMemory(strlen(modname)+1);
	strcpy(ext->modname, modname);
	ext->modnum = id;
	ext->id = 0;
	ext->nonlibs = 0;
	ext->datatype = TY_TYPE;
	if (!(ext->pub = GetPublic(buf)))
		ext->id = newextid++;
	externtable[id] = ext;
}
EXTERN *GetExtern(int i)
{
  return(externtable[i]);
}
void ExternModuleRundown(int mode)
{
	int 	i;
	EXTERN **p = externtable;
	for (i=0; i < MAX_EXTERNS; i++) {
		if (*p) {
			if (!(*p)->pub) {
				LIST *x = AllocateMemory(sizeof(LIST));
				x->link = 0;
				x->data = *p;
				*unresextptr = x;
				unresextptr = &x->link;
			}
			else {
				DeallocateMemory((*p)->modname);
				DeallocateMemory((*p)->name);
				DeallocateMemory(*p);
			}
			*p = 0;
		}
		p++;
	}
}
void ExternTableInit(void)
{
	EXTERN **p;
	int i;
	externtable = AllocateMemory(sizeof(EXTERN *) * MAX_EXTERNS);
	unresextptr = &unresolvedexterns;
	unresolvedexterns = 0;
	p = externtable;
	for (i=0; i < MAX_EXTERNS; i++) {
		*p = 0;
		p++;
	}
}
void ExternTableRundown(void)
{
	LIST *q = unresolvedexterns;
	while (q) {
		LIST *r = q->link;
		EXTERN *p = q->data;
		DeallocateMemory(p->name);
		DeallocateMemory(p->modname);
		DeallocateMemory(p);
		DeallocateMemory(q);
		q = r;
	}
	DeallocateMemory(externtable);
}


		