Intel Hexadecimal Object File

1. Introduction

This document describes the Intel hexadecimal object file records for 8, 16, and 32-bit microprocessors.  This format is suitable for input to PROM programmers or hardware emulators.

This type of format is an ASCII representation of a non-relocatable(absolute)binary program image.  Numbers in this representation are in hexadecimal notation.  Thus the 8-bit binary value 0010-1010 is 2A hexadecimal.  To code this in ASCIItwo 8-bit ASCIIcharacters are required; the character '2' and the character 'A'.  For each 8-bit value the high-order hexadecimal digit is always the first digit of the pair of digits; the lower order hexadecimal digit is always the second digit.  Thus the ASCII representation takes twice as many bytes as the binary representation.

The object file is seperated into records.  Each of these contains the record type, length, memory load address, data, and checksum.  There are currently 6 types different types of records that are defined; however not all combinations of these records are meaningful.The record types are as follows:

a. Start Segment Address Record (16- or 32-bit formats)
b. Start Linear Address Record (32-bit format only)
c. Extended Segment Address Record (16- or 32-bit formats)
d. Extended Linear Address Record (32-bit format only)
e. Data Record (8-, 16-, or 32-bit formats)
f. End of File Record (8-, 16-, or 32-bit formats)

2. General Record Format

M3N3N3N3N3N3K
S  Record Mark S Data LengthSOffset S Type  S  Data S CS S
;3<3<3<3<3<39
 1-byte 1-byte 2-bytes 1-byte  n-bytes  1-byte



a. The Record Mark field is required at the beginning of each record andconsists of the ASCII colon (':') character.

b. The Data Lengthfield specifies the length of the data or information stored in the Data field.  It is Zero for the End Of File record.

c. The Offset field stores the offset to load at when the record is a Data Record; otherwise it is 4 ASCII zeros '0'.

d. The type field specifies the record type, as follows:

d.1. '00' Data Record
d.2. '0l' End of File Record
d.3. '02' Extended Segment Address Record
d.4. '03' Start Segment Address Record
d.5. '04' Extended Linear Address Record
d.6. '05' Start Linear Address Record

e. The data field specifies any data or other information required for this type of record.  The Data field is not specified for an End Of File record.  The contents of this field depends on the contents of the Type
field.

f. The CS (checksum)field is obtained by converting each pair of ASCII digits and adding them together; then taking the twos complement.  Thus the sum of all ASCIIpairs in the record including the checksum field is zero.

3. Extended Linear Address Record (32-bit format only)
+-+-+-+-+-+-+
| RECORD | | LOAD | | | |
| MARK | RECLEN | OFFSET | RECTYP | ULBA | CHKSUM |
| ':' | '02' | '0' | '04' | | |
+-+-+-+-+-+-+


 1-byte 1-byte 2-bytes 1-byte 2-bytes 1-byte


The 32-bit Extended Linear Address Record is used to specify bits 
16-31 of the Linear Base Address (LBA), where bits 0-15 of the LBA are 
zero.  Bits 16-31 of the LBA are referred to as the Upper Linear Base 
Address (ULBA).  The absolut e memory address of a content byte in a 
subsequent Data Record is obtained by adding the LBA to an offset 
calculated by adding the LOAD OFFSET field of the containing Data 
Record to the index of the byte in the Data Record (0, 1, 2, . n).  
This offset add ition is done modulo 4G (i.e., 32-bits), ignoring any 
carry, so that offset wrap-around loading (from OFH to 
OH) results in wrapping around from the end to the beginning of 
the 4G linear address defined by the LBA.  The linear address at whic h 
a particular byte is loaded is calculated as:

 (LBA + DRLO + DRI) MOD 4G

where:

 DRLO is the LOAD OFFSET field of a Data Record.
 DRI is the data byte index within the Data Record.

When an Extended Linear Address Record defines the value of LBA, it 
may appear anywhere within a 32-bit hexadecimal object file. This value 
remains in effect until another Extended Linear Address Record is 
encountered.  The LBA default s to zero until an Extended Linear 
Address Record is encountered.

The contents of the individual fields within the record are:

RECORD MARK

This field contains 03AH, the hexadecimal encoding of the ASCII colon 
(':') character.

RECLEN

The field contains 03032H, the hexadecimal encoding of the ASCII 
characters '02', which is the length, in bytes, of the ULBA data information within this record.<:f>

LOAD OFFSET

This field contains 030303030H, the hexadecimal encoding of the ASCII 
characters '0', since this field is not used for this record.

RECTYP

This field contains 03034H, the hexadecimal encoding of the ASCII 
character  '04', which specifies the record type to be an Extended 
Linear Address Record.

ULBA

This field contains four ASCII hexadecimal digits that specify the 
16-bit Upper Linear Base Address value.  The high-order byte is the 
10th/llth character pair of the record.  The low-order byte is the 
12th/13th character pair of the r ecord.

CHKSUM

This field contains the check sum on the RECLEN, LOAD OFFSET, RECTYP, 
and ULBA fields.

4. Extended Segment Address Record (16- or 32-bit formats)

+-+-+-+-+-+-+
| RECORD | | LOAD | | | |
| MARK | RECLEN | OFFSET | RECTYP | USBA | CHKSUM |
| ':' | '02' | '0' | '02' | | |
+-+-+-+-+-+-+


 1-byte 1-byte 2-bytes 1-byte 2-bytes 1-byte<-!>


The 16-bit Extended Segment Address Record is used to specify bits 
4-19 of the Segment Base Address (SBA), where bits 0-3 of the SBA are 
zero.  Bits 4-19 of the SBA are referred to as the Upper Segment Base 
Address (USBA).  The absolut e memory address of a content byte in a 
subsequent Data Record is obtained by adding the SBA to an offset 
calculated by adding the LOAD OFFSET field of the containing Data 
Record to the index of the byte in the Data Record (0, 1, 2, . n).  
This offset add ition is done modulo 64K (i.e., 16-bits), ignoring any 
carry, so that offset wraparound loading (from OFH to OH) 
results in wrapping around from the end to the beginning of the 64K 
segment defined by the SBA.  The address at which a particular byte i s 
loaded is calculated as:

 SBA +  ([DRLO  +  DRI]  MOD  64K)

where:

 DRLO is the LOAD OFFSET field of a Data Record.
 DRI is the data byte index within the Data Record.

When an Extended Segment Address Record defines the value of SBA, it 
may appear anywhere within a 16-bit hexadecimal object file.  This 
value remains in effect until another Extended Segment Address Record 
is encountered.  The SBA defa ults to zero until an Extended Segment 
Address Record is encountered.

The contents of the individual fields within the record are:

RECORD MARK

This field contains 03AH, the hexadecimal encoding of the ASCII colon 
(':') character.

RECLEN

The field contains 03032H, the hexadecimal encoding of the ASCII 
characters '02', which is the length, in bytes, of the USBA data information within this record.

LOAD OFFSET

This field contains 030303030H, the hexadecimal encoding of the ASCII 
characters '0', since this field is not used for this record.

RECTYP

This field contains 03032H, the hexadecimal encoding of the ASCII 
character '02', which specifies the record type to be an Extended 
Segment Address Record.

USBA

This field contains four ASCII hexadecimal digits that specify the 
16-bit Upper Segment Base Address value.  The high-order byte is the 
10th/1lth character pair of the record.  The low-order byte is the 
12th/1 3th character pair of the record.

CHKSUM

This field contains the check sum on the RECLEN, LOAD OFFSET, RECTYP, 
and USBA fields.


5. Data Record (8-, 16-, or 32-bit formats)

+-+-+-+-+-+-+
| RECORD | | LOAD | | | |
| MARK | RECLEN | OFFSET | RECTYP | DATA | CHKSUM |
| ':' | | | '00' | | |
+-+-+-+-+-+-+


 1-byte 1-byte 2-bytes 1-byte n-bytes 1-byte


The Data Record provides a set of hexadecimal digits that represent 
the ASCII code for data bytes that make up a portion of a memory image.  
The method for calculating the absolute address (linear in the 8-bit 
and 32-bit case and segme nted in the 16-bit case) for each byte of 
data is described in the discussions of the Extended Linear Address 
Record and the Extended Segment Address Record.

The contents of the individual fields within the record are:

RECORD MARK

This field contains 03AH, the hexadecimal encoding of the ASCII colon 
(':') character.

RECLEN

The field contains two ASCII hexadecimal digits that specify the 
number of data bytes in the record.  The maximum value is 'FF' or 
04646H (255 decimal).

LOAD OFFSET

This field contains four ASCII hexadecimal digits representing the 
offset from the LBA (see Extended Linear Address Record) or SBA (see 
Extended Segment Address Record) defining the address which the first 
byte of the data is to be pla ced.

RECTYP

This field contains 03030H, the hexadecimal encoding of the ASCII 
character '00', which specifies the record type to be a Data Record.

DATA

This field contains pairs of ASCII hexadecimal digits, one pair for 
each data byte.

CHKSUM

This field contains the check sum on the RECLEN, LOAD OFFSET, RECTYP, 
and DATA fields.

6. Start Linear Address Record (32-bit format only)

+-+-+-+-+-+-+
| RECORD | | LOAD | | | |
| MARK | RECLEN | OFFSET | RECTYP | EIP | CHKSUM |
| ':' | '04' | '0' | '05' | | |
+-+-+-+-+-+-+

 1-byte 1-byte 2-bytes 1-byte 4-bytes 1-byte


The Start Linear Address Record is used to specify the execution start 
address for the object file.  The value given is the 32-bit linear 
address for the EIP register.  Note that this record only specifies the 
code address within the 3 2-bit linear address space of the 80386.  If 
the code is to start execution in the real mode of the 80386, then the 
Start Segment Address Record should be used instead, since that record 
specifies both the CS and IP register contents necessary for real mode.

The Start Linear Address Record can appear anywhere in a 32-bit 
hexadecimal object file.  If such a record is not present in a 
hexadecimal object file, a loader is free to assign a default start address.

The contents of the individual fields within the record are:

RECORD MARK

This field contains 03AH, the hexadecimal encoding of the ASCII colon 
(':') character.

RECLEN

The field contains 03034H, the hexadecimal encoding of the ASCII 
characters '04',<:f220,2Tms Rmn,0,0,0> which is the length, in bytes, 
of the EIP register content within this record.

LOAD OFFSET

This field contains 030303030H, the hexadecimal encoding of the ASCII 
characters '0', since this field is not used for this record.

RECTYP

This field contains 03035H, the hexadecimal encoding of the ASCII 
character '05', which specifies the record type to be a Start Linear 
Address Record.

EIP

This field contains eight ASCII hexadecimal digits that specify
the 32-bit EIP register contents.  The high-order byte is the 
10th/1lth character pair.

CHKSUM

This field contains the check sum on the RECLEN, LOAD OFFSET, RECTYP, 
and EIP fields.

7. Start Segment Address Record (16- or 32-bit formats)
+-+-+-+-+-+-+
| RECORD | | LOAD | | | |
| MARK | RECLEN | OFFSET | RECTYP | CS/IP | CHKSUM |
| ':' | '04' | '0' | '03' | | |
+-+-+-+-+-+-+

 1-byte 1-byte 2-bytes 1-byte 4-bytes 1-byte


The Start Segment Address Record is used to specify the execution 
start address for the object file.  The value given is the 20-bit 
segment address for the CS and IP registers.  Note that this record 
only specifies the code address wit hin the 20-bit segmented address 
space of the 8086/80186.

The Start Segment Address Record can appear anywhere in a 16-bit 
hexadecimal object file. If such a record is not present in a 
hexadecimal object file, a loader is free to assign a default start address.

The contents of the individual fields within the record are:

RECORD MARK

This field contains 03AH, the hexadecimal encoding of the ASCII colon 
(':') character.

RECLEN

The field contains 03034H, the hexadecimal encoding of the ASCII 
characters '04', which is the length, in bytes, of the CS/IP register contents within this record.

LOAD OFFSET

This field contains 030303030H, the hexadecimal encoding of the ASCII 
characters '0', since this field is not used for this record.

RECTYP

This field contains 03033H, the hexadecimal encoding of the ASCII 
character '03', which specifies the record type to be a Start Segment 
Address Record.

CS/IP

This field contains eight ASCII hexadecimal digits that specify the 16-bit CS register and 16-bit IP
register contents.  The high-order byte of the CS register content is 
the 10th/llth character pair, the low- order byte is the 12th/13th 
character pair of the record.  The high-order byte of the IP register 
content is the 14th/15th character pair, the low-order  byte is the 
16th/17th character pair of the record.

CHKSUM

This field contains the check sum on the RECLEN, LOAD OFFSET, RECTYP, 
and CS/IP fields.

8. End of File Record (8-, 16-, or 32-bit formats)

+-+-+-+-+-+
| RECORD | | LOAD | | |
| MARK | RECLEN | OFFSET | RECTYP | CHKSUM |
| ':' | '00' | '0' | '01' | |
+-+-+-+-+-+

 1-byte 1-byte 2-bytes 1-byte 1-byte


The End of File Record specifies the end of the hexadecimal object 
file.

The contents of the individual fields within the record are:

RECORD  MARK

This field contains 03AH, the hexadecimal encoding of the ASCII colon 
(':') character.

RECLEN

The field contains 03030H, the hexadecimal encoding of the ASCII 
characters '00'.  Since this record does not contain any INFO/DATA 
bytes, the length is zero.

LOAD  OFFSET

This field contains 030303030H, the hexadecimal encoding of the ASCII 
characters '0', since this field is not used for this record.

RECTYP

This field contains 03031H, the hexadecimal encoding of the ASCII 
character '01', which specifies the record type to be an End of File Record.

CHKSUM

This field contains the check sum an the RECLEN, LOAD OFFSET, and 
RECTYP fields.  Since all the fields are static, the check sum can also 
be calculated statically, and the value is 04646H, the hexadecimal 
encoding of the ASCII characte rs 'FF'.
