/*   Simple text editor. Text is represented as char**, every string is
         \r\n - terminated.
*/

#ifndef __WRITE_H_
#define __WRITE_H_

#include "window.h"
#include "strtable.h"

#define STRINGS 250
#define STRING_LEN 120
#define BUFFER_SIZE 100 * STRING_LEN

enum { SAVED = 1, INS = 2 };

class Write : public Window
    {
    protected:
        int mark_begin;  // Line number. We could mark only lines.
        int mark_end;
        int mark;
        char* swapFile;
	int status;
        int total;       // Number of strings
    	char** buffer;
        int line_num;    // Y position, absolute
        loc curs;        // Pixels, on screen
        int xTab;        // Text, on page
        KH_STRTABLE* clip;
    public:
        Write(rect coordinates, char* swapName = "work.txt",
	       char* fName = "", char* h = "",
	       int s = 0, BORDERS b_type = SHOW_BORDER,
	       BORDERS hdr_b_type = SHOW_BORDER,
	       int pat = 0, int hdr_pat = 0);
        virtual ~Write();

        char* getFileName() { return swapFile; }
        void search();
        void set_mark(int begin, int end)
	    { mark_begin = begin; mark_end = end; }
        void set_swap(char* name)
	    {
	    delete swapFile;
	    swapFile = strdup(name);
	    }
        void load_file();
        void unload_file();
        virtual void show();
        virtual void hide();
        void show_text(loc from);
        int getLine(int num);                   // shift in buffer.
        void outtext(int x, int y, char* txt);
        int append(int line_num);
        virtual void exe(int act = 0);
        void swap();
        void showCursor();
        void hideCursor() { showCursor(); }
        virtual void repose(rect r);

        int copy();
        void cut();
        void paste();

        void up(int sh);
	void dn(int sh);
	void left(int sh);
	void right(int sh);
	void home();
	void end();
	void pgUp();
	void pgDn();
	void toTop();
	void toBottom();
	void ctrl_y();
	void del();
	void bksp();
	void processKey(uchar ch);
	void setInsert()
	    {
            int i = status & INS;
	    status = (status & SAVED) | (!i);
	    }

    };

#endif __WRITE_H_
