#include "var_tab.h"
#include <alloc.h>

VarTable::VarTable()
    {
    used = 0;
    size = STEP;
    table = new Variable*[STEP];
    }
//////////////////////
VarTable::~VarTable()
    {
    for(; used > 0; used--)
        delete table[used];
    delete table;
    }
//////////////////////
void VarTable::add(Variable* v)
    {
    if(size == used)
        table = (Variable**)realloc((Variable**)table,
			   (size += STEP) * sizeof(Variable*));
    table[++used] = v;
    }
//////////////////////
int VarTable::assign(double d, char* name)
    {
    Variable* v;
    if((v = find(name)) == NULL)
        {
        v = new Variable(d, name);
	add(v);
        return 1;
        }
    v->type = REAL;
    v->d = d;
    return 1;
    }
//////////////////////
int VarTable::assign(char* s, char* name)
    {
    Variable* v;
    if((v = find(name)) == NULL)
        {
        v = new Variable(s, name);
	add(v);
        return 1;
        }
    v->type = STR;
    delete v->s;
    v->s = strdup(s);
    return 1;
    }
//////////////////////
int VarTable::assign(double* da, char* name)
    {
    Variable* v;
    if((v = find(name)) == NULL)
        {
        v = new Variable(da, name);
	add(v);
        return 1;
        }
    v->type = ARRAY;
    delete v->da;
    v->da = new double[da[0] + 1];
	  memcpy(v->da, da, (da[0] + 1) * sizeof(double));
    return 1;
    }
////////////////////
int VarTable::assign(int index, char* name)
    {
    Variable* v;
    if((v = find(name)) == NULL)
        {
	v = new Variable(index, name);
        add(v);
        }
    else
        {
	if(v->type == ARRAY)
            {
	    delete v->da;
            v->da = new double[index + 1];
            memcpy(v->da, 0, index * sizeof(double));
            return 1;
            }
        return 0;
        }
    return 1;
    }
//////////////////////
int VarTable::assign(double d, char* name, int index)
    {
    Variable* v;
    if((v = find(name)) == NULL)
        {
/*        v = new Variable(da, name);
	add(v);
*/        return 0;
        }
    v->type = ARRAY;
    v->da[index] = d;
    return 1;
    }
//////////////////////
int VarTable::assign(Variable* v)
    {
    Variable* v1;
    if((v1 = find(v->name)) == NULL)
        {
        add(v);
        return 1;
        }

    v1->type = v->type;

    switch(v->type)
        {
        case REAL: v1->d = v->d; break;
        case STR: delete v1->s; v1->s = strdup(v->s); break;
        case ARRAY: delete v1->da; v->da = new double[v->da[0] + 1];
	  memcpy(v1->da, v->da, (v->da[0] + 1) * sizeof(double));
        }
    delete v;
    return 1;
    }
//////////////////////
Variable* VarTable::remove(char* name)
    {
    Variable* v;
    for(int i = 1; i <= used; i++)
        {
        if(strcmp(name, table[i]->name))
            continue;
        else
            {
            v = table[i];
	    break;
            }
        }
    for(; i < used; i++)
        table[i] = table[i + 1];
    used--;
    return v;
    }
////////////////////
Variable* VarTable::find(char* name)
    {
    Variable* v = NULL;
    for(int i = 1; i <= used; i++)
        {
        if(strcmp(name, table[i]->name))
            continue;
        else
            {
            v = table[i];
	    break;
            }
        }
    return v;
    }
