#include "showtext.h"

inline void moveto(loc xy, int dir)
    {
    if(dir)
	moveto(xy.Y, getmaxx() - xy.X);
    else
	moveto(xy);
    }
/////////////////////
inline int getmaxx(int dir)
    {
    if(dir) return getmaxy();
    return getmaxx();
    }
///////////////////
inline int getmaxy(int dir)
    {
    if(dir) return getmaxx();
    return getmaxy();
    }
////////////////////
int text_width(char* str, ljfont* fnt,
	       int zoom_x, int zoom_y)       // correct return len of str, when str is
    {                           // line of deformated characters
    int len = 0;
    char s[2];
    s[1] = '\0';
    int n = strlen(str);
    while(n > 0)
	{
	s[0] = str[n - 1];
	len += fnt->scaledtextsize(s, zoom_x, zoom_y).width();
	n--;
	}
    return len;
    }
//////////////////////////
void ShowText::loadFont(char* fontName)
    {
    delete buffer;
    buffer = new char[5000];
    buffer[0] = '\0';         // end of line
    delete fnt;
    fnt = new ljfont(fontName);
    }
///////////////////////////
void ShowText::show(loc where, char* string, loc scale, int interval,
		    int direction,
		    int mode)
    {
    if(direction)
	where = loc(where.Y, getmaxx() - where.X);

    int len = 0;
    char st[500];
    strncpy(st, string, 499);
    char* s;
    moveto(where, direction);
    while(1)
	{
	s = strchr(string + len, '\n');
	if(s == NULL)
	    {
	    drawscaledstr(*fnt, string + len, scale.X, scale.Y,
			  mode,	direction);
	    break;
	    }
	strncpy(st, string + len, s - string - len);
	st[s - string - len] = '\0';

	len = s - string + 1;
	moveto(where, direction);
	drawscaledstr(*fnt, st, scale.X, scale.Y,
		mode, direction);

	if(direction == HORIZ_DIR)
	    where.Y += interval * fnt->scaledtextsize("H!",
					      scale.X, scale.Y).height() / 10;
	else
	    where.Y -= interval * fnt->scaledtextsize("H!",
					      scale.X, scale.Y).height() / 10;
	moveto(where, direction);
	}
    }
//////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;

    ShowText s;
    s.loadFont("hv08a.sfp");

    s.show(loc(100, 100), "12345678901234567890", loc(2, 2));

    line(0, 100, 200, 100);
    line(100, 0, 100, 200);

    line(0, 200, 200, 200);
    line(200, 0, 200, 200);

    close_KNOW_HOW();
    closegraph();
    }
*/