#ifndef __SCROLLBAR_H_
#define __SCROLLBAR_H_

#include "meter.h"
#include <dos.h>

enum ORIENT { HORIZ, VERT };

class ScrollBar : public Visible
    {
    protected:
        int act;              // Visible or not.
        int len;              // Vertical or Horizontal size, TEXT.
        loc pos;              // Left - top.
        int current;          // Cursor position, absolute.
        int total_len;        // Total number of steps, absolute.
        ORIENT direction;     // 0 - horiz., 1 - vert.
        int pattern;
        Element* e1;
	Element* e2;      // Buttons.
        int page_size;
    public:
        ScrollBar(loc pos, ORIENT type, int len,
	    int tot, int page_size, int cur = 0, int pattern = 0);

        virtual ~ScrollBar() { delete e1; delete e2; }
        virtual void meter_show(loc m, int meter_len, ORIENT direction,
            int p, int pattern);
        int get_pos() { return current; }
        virtual void decrease();
        virtual void increase();
        virtual int get_screen_pos(int meter_len);
        void set_pos(int cur) { current = cur; }
        virtual void repose(rect new_coord);
        void set_page_size(int p) { page_size = p; }
        void set_total(int tot) { total_len = tot; }

        virtual void show();
        virtual void exe(int act = 0);
        virtual rect bound();
        void set_act(int a) { act = a; }
        int mouse_in(loc where);
    };

#endif __SCROLLBAR_H_