#include <assert.h>
#include <mem.h>
#include "pcxstrm.h"

// #define NDEBUG 1

pcxstream::pcxstream(FILE * f): pos(0), file(f)
    {
    buffer = new char[BUFFER_LENGTH];
    assert(buffer);
    fread(buffer, 1, BUFFER_LENGTH, file);
    }
////////////////////
void pcxstream::read(unsigned char * dest, int n)
    {
    if (pos==BUFFER_LENGTH)
	{
	fread(buffer, 1, BUFFER_LENGTH, file);
	pos=0;
	}

    int n_from_buf;
    n_from_buf = pos + n < BUFFER_LENGTH ? n : BUFFER_LENGTH - pos;
    n -= n_from_buf;
    if(n_from_buf)
	{
	memcpy(dest, buffer + pos, n_from_buf);
	pos += n_from_buf;
	}

    while(n > 0)
	{
	pos = 0;
	fread(buffer, 1, BUFFER_LENGTH, file);
	n_from_buf = n < BUFFER_LENGTH ? n : BUFFER_LENGTH;
	n -= n_from_buf;
	if(n_from_buf)
	    {
	    memcpy(dest, buffer + pos, n_from_buf);
	    pos += n_from_buf;
	    }
	}
    }
////////////////////////
pcxstream::~pcxstream()
    {
    delete buffer;
    }
////////////////////////
