#include "oopic.h"
#include <string.h>
#include "nret.h"
#include <dir.h>
#include <errno.h>

void  OOPic::interprete()               // Overloads Slang::interprete()
    {                                   // Some things, like error processing
    int oldtok;                         // differs from Slang:: version
    kh_error_code = KH_SUCCESS;
    do {                                // because this one do not use exit()
	terminate();
	if(error)                  // Error detected
	    {
	    if(sub_used > 0)
		{
		prog = sub_pop();
		return;
		}
	    while(play_used > 1)   // We need clear all nested programs and
		delete playpop();  // "program" itself.
	    delete program;
	    program = NULL;
	    delete variables;            // We also clears all variables
	    variables = new VarTable();  // and initialize them again.
	    return;
	    }
	token_type = get_token();     // Get next lexem
	if(token_type == VARIABLE)    // If it is name (only x = ... or
	    {                         // a[12]... recognized
	    putback();                // Put it back to input stream and
	    assigment();              // make assignment.
	    }
	else
	    switch(oldtok = tok)  // If it is operator or subroutine call
		{
		case GOTO:     slang_goto(); break;   // This block is the
		case LABEL:    find_eol(); break;     // same as in Slang
		case GOSUB:    gosub();    break;     // class. It realize
		case PLAYEX:     play();     break;   // language facilities.
		case PRINT:    print();    break;
		case IF:       slang_if();  break;
		case FOR:      slang_for(); break;
		case NEXT:     next();     break;
		case INPUT:    input();    break;
		case RETURN:   sub_return();  break;
		case PAUSE:    pause(); break;

		case LINE: Line(); break;            // This block contain
		case LINETO: lineTo(); break;        // painting perators
		case ELLIPSE: Ellipse(); break;      // which are specific
		case RECTANGLE: Rectangle(); break;  // for OOPic class.
		case POLY: Poly(); break;
		case TXT: text(); break;

		case ZOOM: zoom_picture(); break;
		case ADDZOOM: add_zoom_picture(); break;
		case SCROLL: scroll(); break;
		case ADDSCROLL: add_Scroll(); break;
		case MIRROR: Mirror(); break;
		case ROTATE_ON: set_stack(ON); break;
		case ROTATE_OFF: set_stack(OFF); break;
		case ENDROTATE: r_stack->pop();  break;

		case SETCOLOR: setcolor(); break;
		case SETCOLOR_RGB: setcolor_RGB(); break;

		case SETFILLSTYLE: setfillstyle(); break;
		case SETTEXTSIZE: settextsize(); break;
		case SETFONT: setfont(); break;
		case SETFILL: setfill(); break;
		case MOVETO: moveTo(); break;
		case ROTATE: rotate(); break;
		case SETLINE: setline(); break;

		case END:                 // End of "main" or played program.
		    if(play_used == 1)    // If it is main program, then
			return;           // no action is taken.

		    delete playpop();     // If we play external file, pop
					  // it from program stack, and
		    delete program;
		    play_stack* p_s;      // Then we load previous file
		    program = load_program((p_s = playpop())->prog);
		    prog = program + p_s->shift;
		    delete p_s;
		    scan_labels();        // And scan it for labels
		    break;
		}
	} while((oldtok != FINISHED ) && (oldtok != RETURN));
    }
//////////////////////
void OOPic::rotate()
    {
    if(error)
	return;

    double a, x, y;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&a) || get_argument(&x) || get_argument(&y))
	{
	serror(0);
	return;
	}
    alpha = (int)(a);
    center.X = (int)x;
    center.Y = (int)y;

    Paint::rotate(center, alpha);
    }
/////////////////////
void OOPic::zoom_picture()
    {
    if(error)
	return;

    double zx, zy;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&zx) || get_argument(&zy) || zx <= 0 || zy <= 0)
	{
	serror(0);
	return;
	}

    Paint::set_zoom(zx, zy);
    }
//////////////////////
void OOPic::add_zoom_picture()
    {
    if(error)
	return;

    double zx, zy;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&zx) || get_argument(&zy) || zx <= 0 || zy <= 0)
	{
	serror(0);
	return;
	}
    Paint::set_add_zoom(zx, zy);
    }
//////////////////////
void OOPic::setline()
    {
    if(error)
	return;

    double w, z;                // width, style
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&w) || get_argument(&z) || z < 0)
	{
	serror(0);
	return;
	}
    KH_Paint::setlinestyle(w, z);
    }
//////////////////////
//////////////////////
void OOPic::Mirror()
    {
    if(error)
	return;

    double z;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&z))
	{
	serror(0);
	return;
	}
    set_mirror((int)z);
    }
/////////////////
void OOPic::scroll()
    {
    if(error)
	return;

    double x, y;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x) || get_argument(&y))
	{
	serror(0);
	return;
	}
    Paint::set_scroll((int)x, (int)y);
    }
//////////////////////
void OOPic::add_Scroll()
    {
    if(error)
	return;

    double x, y;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x) || get_argument(&y))
	{
	serror(0);
	return;
	}
    Paint::set_add_scroll((int)x, (int)y);
    }
//////////////////////
void OOPic::Line() // LINE(X1, Y1, X2, Y2)
    {
    if(error)
	return;

    double x1, y1, x2, y2;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x1) || get_argument(&y1) || get_argument(&x2)
       || get_argument(&y2))
	{
	serror(0);
	return;
	}

    line(x1, y1, x2, y2);
    moveto(x2, y2);
    }
//////////////
void OOPic::moveTo()
    {
    if(error)
	return;

    double x, y;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x) || get_argument(&y))
	{
	serror(0);
	return;
	}
    moveto(x, y);
    }
/////////////////
int OOPic::get_argument(double* x)
    {
/*    get_token();   // line argument
    if(token_type != VARIABLE && token_type != NUMBER
	&& token_type != COMMAND && token[0] != '-')
	return 1;
    putback();
*/
    get_exp(x);
    return 0;
    }
////////////////////
void OOPic::setcolor()
    {
    if(error)
	return;

    double col;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&col))
	{
	serror(2);
	return;
	}
    KH_Paint::setcolor(col);
    }
/////////////////
void OOPic::setcolor_RGB()
    {
    if(error)
	return;

    double r,g,b;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&r) || get_argument(&g) || get_argument(&b))
	{
	serror(2);
	return;
	}
    KH_Paint::setcolor(r,g,b);
    }
/////////////////
void OOPic::setfillstyle()
    {
    if(error)
	return;

    double fstyle, col;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&fstyle) || get_argument(&col))
	{
	serror(2);
	return;
	}
    KH_Paint::setfillstyle(fstyle, (int)col);
    }
/////////////////
void OOPic::setfont()
    {
    if(error)
	return;

    char font[MAXPATH];
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    get_token();
    strcpy(font, token);
    BGI_Font::load(font);

    if(kh_error_code)
	{
	serror(20);
	return;
	}
    }
/////////////////
void OOPic::settextsize()
    {
    if(error)
	return;

    double mx, dx, my,dy;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&mx) || get_argument(&dx) || get_argument(&my)
	|| get_argument(&dy))
	{
	serror(2);
	return;
	}
    BGI_Font::setusercharsize(mx, dx, my, dy);
    }
/////////////////
void OOPic::setfill()
    {
    if(error)
	return;

    double f;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&f))
	{
	serror(2);
	return;
	}
    fill = f;
    }
////////////////////
void OOPic::lineTo()
    {
    if(error)
	return;

    double x, y;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x) || get_argument(&y))
	{
	serror(2);
	return;
	}
    lineto(x, y);
    }
////////////////////
void OOPic::Ellipse()
    {
    if(error)
	return;

    double x, y, stangle, endangle, xradius, yradius;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x) || get_argument(&y) || get_argument(&stangle)
       || get_argument(&endangle) || get_argument(&xradius)
       || get_argument(&yradius))
	{
	serror(2);
	return;
	}
    ellipse(x, y, stangle, endangle, xradius, yradius);
    }
////////////////////
void OOPic::Rectangle()
    {
    if(error)
	return;

    double x1, y1, x2, y2;
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x1) || get_argument(&y1) || get_argument(&x2)
       || get_argument(&y2))
	{
	serror(2);
	return;
	}

    rectangle(x1, y1, x2, y2);
    }
////////////////////
void OOPic::Poly()
    {
    if(error)
	return;

    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}

    double num_points;
    if(get_argument(&num_points))
	{
	serror(2);
	return;
	}
    int* points = new int[num_points * 2 + 1];
    double work;
    for(int i = 0; i < 2 * num_points; i++)
	{
	if(get_argument(&work))
	    {
	    delete points;
	    serror(15);
	    return;
	    }
	points[i] = (int)work;
	}

    if(fill)
	fillpoly(num_points, points);
    else
	drawpoly(num_points, points);
    delete points;
    }
////////////////////
void OOPic::text()
    {
    if(error)
	return;

    double x, y;
    char str[80];
    get_token();    // "("
    if(*token != '(')
	{
	serror(1);
	return;
	}
    if(get_argument(&x) || get_argument(&y))
	{
	serror(2);
	return;
	}

    get_token();                     // '"...' or value of var
    if(token_type == QUOTE)          // it is string
	strcpy(str, token);
    else                             // it is a = (real)b or a = (str)b
	{
	putback();
	double value;
	char* str_value = get_exp(&value);
	switch(variable_type)
	    {
	    case STR :  strcpy(str, str_value); break;
	    default:
		sprintf(str, "%f", value);
		break;
	    }
	}
    BGI_Font::outtextxy(x, y, str);
    }
////////////////////
void OOPic::serror(int err)   // rewrite to obtain position of error
    {
    KH_Paint::setcolor(WHITE);
    KH_Paint::setlinestyle(1, 0);
    KH_Paint::setfillstyle(SOLID_FILL, BLUE);
    KH_Paint::setusercharsize(1,1,1,1);
    fill = ON;
    BGI_Font::load("litt.chr");
    KH_Paint::set_zoom(1,1);
    KH_Paint::set_add_zoom(1,1);
    KH_Paint::set_scroll(0,0);
    KH_Paint::set_add_scroll(0,0);
    KH_Paint::set_stack(OFF);

    rectangle(0, 0, 320, 80);

    char c = prog[0];                       // Get line number
    prog[0] = '\0';
    char ln[5];
    itoa(nRet(program) + 1, ln, 10);
    prog[0] = c;

    outtextxy(10, 15, "line: ");
    outtextxy(10 + gettextwidth("line: "), 15, ln);
    outtextxy(10, 30, "; file: ");
    outtextxy(10 + gettextwidth("; file: "), 30, playstack[play_used]->prog);
    outtextxy(10, 45, error_string[err]);
    error = 1;
    }
//////////////////////////
///////////////////////// DOS Demo //////////////////////////////////////////
/*
#include <conio.h>     // only for interruption on key pressed **************
class Demo : public OOPic
    {
    virtual void terminate();  // User-defined terminator (ESC and so on)
    };
/////////////
void Demo::terminate()
    {
    if(kbhit())
	{
	getch();
	if(kbhit())
	    getch();
	serror(23);
	}
    }

void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    Demo* basic = new Demo();
//    basic->basic(basic->load_program("oopic.vec"));
    char s[80] = "mirror(0,0)\r\nrotate(0,0,0)\r\nleft=10\r\ntop=10\r\nright=200\r\nbottom=200";
    basic->basic(s);
    char s1[80] = "color(15):style(1,7):header=\"Hello\"font(\"litt.chr\"):textsize(1,1,1,1)";
    basic->basic(s1);
    basic->basic(basic->load_program("window.vec"));
    delete basic;

    closegraph();
    }
*/
/*
////////////////////////// GDI Windows Demo ////////////////////////
// This example demonstrates output to OWL window. If necessary,
// any other Windows library could be used.

#include <owl.h>
class Demo : public OOPic
    {
    public:
	void demo();
    };
///////////////////
void Demo::demo()
    {
    basic(load_program("oopic.vec"));
    }
class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow, public Demo
{
public:
  TMyWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle), Demo() { DC = GetDC(HWindow); }
  virtual void WMLButtonDown(RTMessage Msg)
    = [WM_FIRST + WM_LBUTTONDOWN];
};

void TMyWindow::WMLButtonDown(RTMessage)
    {
    DC = GetDC(HWindow);
    demo();
    }

void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("Sample KNOW-HOW.GRAPHICS Program", hInstance, hPrevInstance,
	       lpCmdLine, nCmdShow);
  MyApp.Run();
  return MyApp.Status;
}

*/