/* FRAME.H   Frame is a Carcase with Shadow.
   It is start object for Wundow, Button and other, so it remembers
   its coordinates.
*/

#ifndef __FRAME_H_
#define __FRAME_H_

#include "output.h"
#include "carcase.h"
#include "shadow.h"

enum { TEXT, SCREEN };  // determines in which units we give the coordinates

class Frame : public Carcase, public Shadow
    {
    protected:
        int tog;        // TEXT (0) OR GRAPHICS (1)
	rect rectangle; // left, top, right, bottom
	int shadow;     // = 0 if no shadow
	BORDERS border_type;  // 0 - no, 1 ... different types.
    public:
	Frame(rect coordinates, BORDERS b_type = STANDART_BORDER, int s = 0,
	      int t = 0);

	void show();       // Draw Frame (Carcase + Shadow)
	void hilite();     // Draw HILITE_BORDER
	void unhilite();   // Restore border type
	void press();      // Draw PRESS_BORDER. Use for BUTTON_BORDER.
	void release();    // Restore hilited border type after press().
        void set_rect(rect r) { rectangle = r; }
    };

#endif __FRAME_H_