#include "graphpp.h"
#include <dos.h>
#include "pixel.h"
#include "effects.h"
#include "tools.h"

///////////////////////
void replace_color(rect work, int weight, int pat)
    {
    if(global_i[7] != global_i[6])
	if(global_i[8] == 0)
	    {
	    for(int i = work.origin.X; i <= work.corner.X; i++)
		for(int j = work.origin.Y; j <= work.corner.Y; j++)
		    if(getpixel(i, j) == global_i[6])
			put_pixel(i, j, weight);
	    }
	else
	    for(int i = work.origin.X; i <= work.corner.X; i++)
		for(int j = work.origin.Y; j <= work.corner.Y; j++)
		    if(getpixel(i, j) == global_i[6])
			put_pixel_error_prop(i, j, weight, pat);
    }
///////////////////////
void color_bar(rect work, int weight, int pat)
    {
    int x, y;
    if(global_i[8] == 0)    // no error propagation
	{
	for(x = work.origin.X; x < work.corner.X; x++)
	    for(y = work.origin.Y; y < work.corner.Y; y++)
		{
		put_pixel(x, y, weight);
		}
	}
    else
	for(x = work.origin.X; x < work.corner.X; x++)
	    for(y = work.origin.Y; y < work.corner.Y; y++)
		{
		put_pixel_error_prop(x, y, weight, pat);
		}

    }
///////////////////////
void process_color(rect work,
    int weight = global_i[9], int pat = 16)
    {
    if(global_i[12] == TOOL_ERASER         // DATA_TOOLS
       || global_i[12] == TOOL_SCISSORS)
	color_bar(work, weight, pat);
    else
	replace_color(work, weight, pat);
    }
//////////////////////
void color_grad(rect work, int direction)
    {
    int w = work.width();
    int h = work.height();
    int slices, step_x, step_y;
    if(global_i[8] == 0)
	slices = 16;
    else
	if(direction == 1)    // HORIZ_GRAD
	    slices = w;
	else if(direction == 2)
	    slices = h;
    if(direction == 1)    // HORIZ_GRAD
	{
	step_x = w / slices;
	if(step_x == 0)
	    return;
	}
    else if(direction == 2)
	{
	step_y = h / slices;
	if(step_y == 0)
	    return;
	}
    int i;
    switch(direction)
	{
	case 1:                                   // HORIZONTAL GRADIENT
	    for(i = 0; i < slices; i++)
		{
		process_color(rect(work.origin.X + i * step_x, work.origin.Y,
			work.origin.X + (i + 1) * step_x, work.corner.Y),
			i, slices);
		}
	    break;
	case 2:                                     // VERTICAL GRADIENT
	    for(i = 0; i < slices; i++)
		{
		process_color(rect(work.origin.X, work.origin.Y  + i * step_y,
			work.corner.X + 1, work.origin.Y + (i + 1) * step_y),
			i, slices);
		}
	    break;
	default:        // no gradient
	    process_color(work, global_i[9], 48);
	    break;
	}
    }
/////////////////////////////
