#include "dim.h"
#include "event.h"
#include "global.h"
#include "pcx.h"


#define MDN (MCleftDn|MCrightDn)

#ifndef DATA_TOOLS
#define DATA_TOOLS 1
#endif  DATA_TOOLS


void show_fig(int fig_type, rect start)
    {
    switch(fig_type)
	{
	case FIG_RECTANGLE:
	    ::rectangle(start);
	    break;
	case FIG_LINE:
	    ::line(start.origin, start.corner);
	    break;
	case FIG_CIRCLE:
	    setlinestyle(SOLID_LINE, 1, 3);
	    ::ellipse(start.origin.X + start.width() / 2,
		    start.origin.Y + start.height() / 2, 0, 360,
		    start.width() / 2, start.height() / 2);
	    break;
        case FIG_PCX:
            pcx_file_scr("copy.pcy", start.origin, NULL, XOR_PUT);
            break;
	}

    }
//////////////////////
void hide_fig(int fig_type, rect start)
    {
    show_fig(fig_type, start);
    }
//////////////////////
rect change_pos(int fig_type, int act_type, rect start, loc minsize,
                loc step, rect r)
    {
    loc delta(0, 0);
    if(e.what == MOUSEEVENT)   // it is mouse
	delta = e.where() - start.corner;
    else                       // it is key
	switch(e.key)
	    {
	    case EVENT_LEFT:
		if(fig_type == FIG_LINE || (start.width() >= minsize.X
		    && start.corner.X > minsize.X))
		    delta = loc(-step.X, 0);
		break;
	    case EVENT_RIGHT:
		if(start.corner.X <= getmaxx() - step.X)
		    delta = loc(step.X, 0);
		break;
	    case EVENT_UP:
		if(fig_type == FIG_LINE || (start.height() >= minsize.Y
		    && start.corner.Y > minsize.Y))
		    delta = loc(0, -step.Y);
		break;
	    case EVENT_DN:
		if(start.corner.Y <= getmaxx() - step.Y)
		    delta = loc(0, step.Y);
		break;
	    default: return start;
	    }

    rect ok;

    if(act_type == MOVE)
	ok = start + delta;
    else                               // RESIZE
	{
	if((fig_type != FIG_LINE)
	    && (start.corner.X + delta.X < start.origin.X + minsize.X
	    || start.corner.Y + delta.Y < start.origin.Y + minsize.Y))
	    delta = loc(0, 0);
        ok = rect(start.origin, start.corner + delta);
	}

//    ok.sort();

    mouseSetPosition(ok.corner);
    if(fig_type == FIG_CIRCLE && (ok.width() < 0 || ok.height() < 0))
	{
	ok = rect(ok.origin, ok.origin);
	}
    if(!r.contains(ok))
        ok = start;
    hide_fig(fig_type, start);
    show_fig(fig_type, ok);

    return ok;
    }
/////////////////////////////////
rect get_dim(int fig_type, int act_type, rect r, rect start, loc minsize,
    loc step)
    {
    mouseSetPosition(start.corner);
    readevent(MOUSEEVENT);
    mouseSetRange(rect(r.origin + minsize, r.corner));
    mouseHideCursor();
    setwritemode(XOR_PUT);
    int color = getcolor();
    setcolor(WHITE);

    setlinestyle(SOLID_LINE, 1, 1);

    show_fig(fig_type, start);                 // show ruber figure first time

    int key;
    while(1)
	{
	if(scriptMode == GO)
	    e = getevent(KEYEVENT | MOUSEEVENT,
			 MCmove | MCleftDn | MCrightDn);
	else
	    get_event();

	if((e.what == MOUSEEVENT && (key = e.mousechange & MDN))   // mouse button pressed
	    || (e.what == KEYEVENT
		&& (e.key == EVENT_RETURN || e.key == EVENT_ESC)))
	    {
	    hide_fig(fig_type, start);        // hide ruber figure last time
	    mouseShowCursor();
	    mouseDefaultRange();

	    setwritemode(COPY_PUT);
	    setcolor(color);

	    return (e.what == KEYEVENT && e.key == EVENT_RETURN)
		|| (e.what == MOUSEEVENT && key == MCleftDn)  // left - do it,
		? start : rect(0, 0, 0, 0);             // right - cancel
	    }

	start = change_pos(fig_type, act_type, start, minsize, step, r);

	}

    }