#include "bltpxtab.h"

BlockTPXTable::BlockTPXTable(rect coordinates,
	       char* tabName,
	       char* fName,
	       char* h,
	       int s,
	       BORDERS b_type,
	       BORDERS hdr_b_type,
	       int res,
	       int hdr_pat,
	       int elem_pat,
	       int fNo,
	       char** fields,
	       char** types)
	: BlockPXTable(coordinates, tabName, fName, h, s, b_type,
	       hdr_b_type, res, hdr_pat, elem_pat, fNo, fields, types)
    {
    int xl = coordinates.origin.X + 1;
    int yt = coordinates.corner.Y - 3;
    int yb = coordinates.corner.Y - 2;

    f_first_button = new Button(rect(xl + 13, yt, xl + 24, yb),
	"Find First", BUTTON_BORDER, elem_pat);
    f_next_button = new Button(rect(xl + 13, yt + 1, xl + 24, yb + 1),
	"Find Next", BUTTON_BORDER, elem_pat);
    rotate_button = new Button(rect(xl + 24, yt, xl + 31, yb),
	"Rotate", BUTTON_BORDER, elem_pat);
    edit_button = new Button(rect(xl + 24, yt + 1, xl + 31, yb + 1),
	"Edit", BUTTON_BORDER, elem_pat);

    add(f_first_button);
    add(f_next_button);
    add(rotate_button);
    add(edit_button);

    assign(table, f_first_button, AC_FIND_FIRST);
    assign(table, f_next_button, AC_FIND_NEXT);
    assign(table, rotate_button, AC_NEXT);
    assign(table, edit_button, AC_EDIT);
    }
/////////////////////////////////
void BlockTPXTable::rearrange()
    {
    BlockPXTable::rearrange();
    rect r;
    rect coord = textRect(r = w1->bound());

    int xl = coord.origin.X + 1;
    int yt = coord.corner.Y - 3;
    int yb = coord.corner.Y - 2;

    f_first_button->repose(rect(xl + 13, yt, xl + 24, yb));
    f_next_button->repose(rect(xl + 13, yt + 1, xl + 24, yb + 1));
    rotate_button->repose(rect(xl + 24, yt, xl + 31, yb));
    edit_button->repose(rect(xl + 24, yt + 1, xl + 31, yb + 1));
    }
/////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    if(PXInit() != PXSUCCESS)
	return;

    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    BlockTPXTable w(rect(10, 2, 78, 18), "demo.db", "window.pcy",
	" KNOW-HOW 4.x", 3, SHOW_BORDER, SHOW_BORDER, MOVE | RESIZE, 19, 0);

    w.show_window();
    w.exe();
    w.hide();

    PXExit();
    close_KNOW_HOW();
    closegraph();
    }
*/