#include "buff.h";

//
//  Written by: RAM MACHNESS                                                  
//  Started on: 24-11-1991                                                    
//

BUFF::BUFF()
{
    const unsigned length= 256;

    buff= new BYTE[length];

    if (buff== NULL)
         return; // not enough memory.

    alloc_len= buff_len= length;
    head= current_length= 0;
    self_allocated= TRUE;
}

BUFF::BUFF(const unsigned length)  //self allocated constructor
{
    if (length== 0)
       return; // allocation error.

    buff= new BYTE[length];
    if (buff== NULL)
       return; // not enough memory.

    alloc_len= buff_len= length;
    head= current_length= 0;
    self_allocated= TRUE;
}


BUFF::BUFF(const BUFF&    source_buff)         //copy constructor
{
    // ͻ
    // before changing this code- please check operator= . 
    // ͼ
    buff= new BYTE[source_buff.buff_len];
    if (buff== NULL)
       return; // allocation failure (not enough memory).

    alloc_len= buff_len= source_buff.buff_len;
    head= 0;
    self_allocated= TRUE;
    current_length= source_buff.current_length;

    for (INDEX i= 0; i< source_buff.buff_len; i++)
           buff[i]= source_buff[i];
}


BUFF::BUFF(const BUFF&    source_buff,       //blocking constructor-
                                             //based on other buff
           const INDEX    block_start ,      //zero represents the first
                                             //item on buff
           const INDEX    block_len)         //default is the last item
                                             //on source buff
{
    if (block_len== 0)
       return; // not enough memory.

    // ͻ
    // block start is cyclic. 
    // ͼ
    head= ((block_start+ source_buff.head)% source_buff.buff_len);


    // ͻ
    // current lebgth will be block len unless the size of the new buff is    
    //      larger than the original buff len. In this case,the current length
    //      will be the remaining number of items left from the original      
    //      buff. (start counting at head).                                   
    // ͼ
    current_length= ((block_len+ head)> source_buff.buff_len)?
                  (source_buff.buff_len- head): block_len;

    buff_len=source_buff.buff_len;
    buff= source_buff.buff;
    self_allocated= FALSE;
    alloc_len= 0;
}


BUFF::~BUFF()                                  //destructor
{
    if (self_allocated)
       delete (buff);
}

void BUFF::operator= (const BUFF& source_buff)
{
    if (self_allocated)
       delete (buff);

    // ͻ
    // this source code was copied off of the copy constructor 
    // ͼ
    buff= new BYTE[source_buff.buff_len];

    if (buff== NULL)
       return; // not enough memory.

    alloc_len= buff_len= source_buff.buff_len;
    head= 0;
    self_allocated= TRUE;
    current_length= source_buff.current_length;

    for (INDEX i= 0;i< source_buff.buff_len; i++)
           buff[i]= source_buff[i];
}

unsigned BUFF::len(void) const  //function returning the current length of buffer.
{
    return current_length;
}

BUFF_OP  BUFF::operator<< (const BYTE in_byte) //function inserts byte to buffer
{
    if (!self_allocated)
       return BUFF_FAILURE;
    if (current_length== buff_len)
       return BUFF_OVERFLOW;

    buff[(head+ current_length)% buff_len]= in_byte;
    current_length++;

    if (current_length== 1)
       return BUFF_SINGLE_ITEM;
    if (current_length== buff_len)
       return BUFF_FULL;
    return BUFF_READY;
}

BUFF_OP  BUFF::operator>> (BYTE& out_byte) //function gets byte on head of buff.
{
    if (!self_allocated)
       return BUFF_FAILURE;
    if (current_length== 0)
       return BUFF_UNDERFLOW;

    out_byte= buff[head];
    head= ((head+ 1)% buff_len);
    current_length--;

    if (current_length== 0)
       return BUFF_EMPTY;
    if (current_length== 1)
       return BUFF_SINGLE_ITEM;
    return BUFF_READY;
}

BUFF_OP  BUFF::operator>  (BYTE& out_byte) //function to see byte on head of
                                           //buff without poping it out.
{
    if (current_length== 0)
       return BUFF_UNDERFLOW;

    out_byte= buff[head];

    if (current_length== 0)
       return BUFF_EMPTY;
    if (current_length== 1)
       return BUFF_SINGLE_ITEM;
    return BUFF_READY;
}

BUFF_OP  BUFF::operator<< (const BUFF& other_buff)  //function to add another
                                                    //buff to the sertain buffer
{
    if (!self_allocated)
       return BUFF_FAILURE;

    // ͻ
    // checking if we need to change size of buffer 
    // ͼ
    if ((current_length+ other_buff.current_length)> buff_len)
       reset_size((current_length+ other_buff.current_length),/*reset=*/FALSE);

    // ͻ
    // copy all items 
    // ͼ
    for (int i= 0; i< other_buff.current_length; i++)
           (*this)<< other_buff[i];


    if (current_length== 0)
       return BUFF_EMPTY;
    if (current_length== 1)
       return BUFF_SINGLE_ITEM;
    if (current_length== buff_len)
       return BUFF_FULL;
    return BUFF_READY;
}

void BUFF::empty_buff(void)                     //function to empty the buff
{
    if (self_allocated)
       head= current_length= 0;
}

BYTE BUFF::operator[]  (const INDEX index) const //function to see an item
                                                 //according to index.
                                                 //you may enter any index.
{
    return buff[(head+ index)% buff_len];
}

BYTE& BUFF::operator[]  (const INDEX index) //function to see an item according
                                            //to index. you may enter any index.
{
    return buff[(head+ index)% buff_len];
}

BUFF_OP BUFF::reset_size  (const unsigned new_size,  //function to change buffer
                           const BOOLEAN  reset)     //size and reset it.
{
    if (!self_allocated)
       return BUFF_FAILURE;

    if (new_size== 0)
       return BUFF_FAILURE; // error in parameter.

    // ͻ
    // checking if we need to allocate new space 
    // ͼ
    if (alloc_len< new_size) {
       // ͻ
       // allocating new buff 
       // ͼ
       BYTE* new_buff= new BYTE[new_size];
       if (new_buff== NULL)
          return BUFF_FAILURE; // not enough memory.

       // ͻ
       // do we need to copy the original buff? 
       // ͼ
       if (!reset)
          for (int i= 0; (i<= new_size) && (i<= current_length); i++)
              new_buff[i]= (*this)[i];

       delete (buff);
       buff= new_buff;
       head= 0;
       alloc_len= new_size;
    }

    if (reset)
       current_length= 0;
    else
        current_length= (new_size> current_length) ? current_length : new_size;

    buff_len= new_size;

    if (current_length== 0)
       return BUFF_EMPTY;
    if (current_length== 1)
       return BUFF_SINGLE_ITEM;
    if (current_length== buff_len)
       return BUFF_FULL;
    return BUFF_READY;
}
