///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: DosFree.h                                            //
//            started on: 28/7/93                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  DosFree allows you to use dos within your TSRs. Just derive from     //
//    this class and call func. Go and your dos-free application         //
//    overloading func. AppFunc will run as soon as dos is free.         //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                    by Ofer Laor (AKA LeucroTTA)                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef __DOSFREE_H
#define __DOSFREE_H

#include "isc.h"; // ISC.


// dos IDLE interrupt hook.
class INT28 : public ISC {

      virtual void isr(void);

protected:
      virtual void ShellFunc(void) {};    // DOSFREE shell.
      virtual void DosIdleHook(void) {};  // overload this function to use Idle interrupt within APP.

      INT28() : ISC() {
              activate(0x28);
      };
};

// timer interrupt hook.
class INT8 : public ISC {

      virtual void isr(void);
protected:
      char far *inDOS;
      virtual void ShellFunc(void) {};    // DOSFREE shell.
      virtual void TimerHook(void) {};    // overload this function to use Timer interrupt within APP.
      INT8();
};


// trap for critical errors.
class TRAP : public ISC {

      virtual void isr(void) {};
public:
       TRAP() {};
};

// trap for Abort/Retry/Fail.--> converts to always Fail.
class TRAP24 : public ISC {

      virtual void isr(IREGS& regs);
public:
       TRAP24() {};
};


// Dosfree
class DOSFREE : public INT8, public INT28 {

      int fRunning;                 // is app activated?
      virtual void ShellFunc(void); // saves DOS data so that AppFunc can run free.
protected:

      TRAP TrapCBreak;
      TRAP TrapMSDOSCriticalError;
      TRAP24 TrapAbortRetryFail;

      virtual void AppFunc(void);   // overload this function.
      DOSFREE();                    // prevent direct usage of DOSFREE (use derive classes only).

public:
       void Go(void);               // call this func. to activate AppFunc.

};


#endif /* __DOSFREE_H */
