; +---------+---------------------------------------------------+
; | Minitel | A Very Small Communications Pacakage              |
; +---------+---------------------------------------------------+
;
; Copyright (c) 1999 Noah Paul, <noahp@altavista.net>
; 
; To be distributed only under the GNU General Public License.
;
; Everyone should be forced to write a communications package in assembly
; language. It gives people a sense of how huge 4096 bytes really is. 
;
; Minitel is very easy to use. If you can't figure it out, seek help and
; forget about trying to get online. You'll only piss people off.
;
; PLATFORM:		8086+, a certian glorified interrupt handler
; AUTHOR:		Noah Paul <noahp@altavista.net>
; LICENSE:		GNU General Public License
;
; This is my first assembly language program. Bear with me. Send me *ANY*
; comments, even flamish ones.
;
	IDEAL 
	
	MODEL	small

	STACK	0		; keep TLINK happy by not omitting STACK 
				; I don't think this affects anything

	DATASEG

Copyright	DB	10,13
DB "͸",10,13
DB " MINITEL  A Very Small Communications Package ",10,13
DB ";",10,13
DB 10,13
DB "Copyright (c) 1999 by Noah Paul, <noahp@altavista.net>",10,13
DB "To be distributed only under the GNU General Public License.",10,13
DB 10,13,'$'

menu_Port	DB	10,13
DB "͸",10,13
DB " Select COM Port                         ",10,13
DB ";",10,13
DB "          1. COM1 ",10,13
DB "          2. COM2 ",10,13
DB "          3. COM3 ",10,13
DB "          4. COM4 ",10,13       
DB "         ",10,13
DB "--> $"

menu_Baud	DB	10,13
DB "͸",10,13
DB " Select Baud Rate                        ",10,13
DB ";",10,13
DB "          1. 110   2. 150   3. 300   ",10,13
DB "          4. 600   5. 1200  6. 2400  ",10,13
DB "          7. 4800  8. 9600 and up    ",10,13       
DB "         ",10,13
DB "--> $"

menu_Parity	DB	10,13
DB "͸",10,13
DB " Select Parity                           ",10,13
DB ";",10,13
DB "          1. None  2. Odd   3. Even  ",10,13
DB "         ",10,13
DB "--> $"

menu_DataBits	DB	10,13
DB "͸",10,13
DB " Select Data Bits                        ",10,13
DB ";",10,13
DB "          1. 7 bits (ASCII)          ",10,13
DB "          2. 8 bits (Euro,IBM,etc.)  ",10,13       
DB "         ",10,13
DB "--> $"
 
menu_StopBits	DB	10,13
DB "͸",10,13
DB " Select Stop Bits                        ",10,13
DB ";",10,13
DB "          1. One stop bit  ",10,13
DB "          2. Two stop bits ",10,13       
DB "         ",10,13
DB "--> $"


Invalid		DB	"Invalid value. Please choose one from the menu.$"
PressAnyKey	DB	"Press any key to continue . . .$"

CRLF		DB	10,13,'$'
BackSpace	DB	8,' ','$'

Baud		DB	?		; This will hold (wow) the Baud rate
StopBits	DB	?		; For these, a previous definition
DataBits	DB	?		; is not useful, not to mention
Parity		DB	?		; it wastes a precious machine
Port		DW	?		; cycle (or two!) :)

StartCommMesg	DB	13,"Ctrl-R: Reconfigure  Ctrl-V: Quote  Ctrl-E: Toggle Echo  Esc: Quit",10,13,'$'

ChStr		DB	?,'$'		; Please don't ask.

Quoted		DB	0		; Is the character quoted?
Echo		DB	0		; Should we echo characters?

ErrorIn		DB	"<<RECV ERROR>>$"
ErrorOut	DB	"<<SEND ERROR>>$"
		
						
	CODESEG


; ClrScr - Clear Screen
;
; Destroys:	Just about everything :(  	
; Takes:	nothing
; Returns:	nothing

MACRO	ClrScr	

	CALL	ClrScrP			; These macros are easier to use

ENDM
 
PROC	ClrScrP

	MOV	ah,6h		; Service #6 - Scroll or Clear Screen
	XOR	al,al		; Faster under 8086 - 286 than MOV al,0
	MOV	bh,1h		;     
	XOR	cl,cl		; XOR x,x is the same as MOV x,0
	XOR	ch,ch		; Set Window & # of lines to scroll
	MOV	dl,79		; 79,
	MOV	dh,24 		; 24
	INT	10h		; Call BIOS

	MOV	ah,2h		; GotoXY
	XOR	bx,bx		; Page (IB)
	XOR	dh,dh		; X,
	XOR	dl,dh		; Y 
	INT	10h

	RET

ENDP	ClrScrP


; WriteCharAL - Write a character in AL.    
;
; Caution:	DO *NOT* PASS ARGUMENT IN 'AL'. PATENTLY BAD THINGS HAPPEN.
; Destroys: 	AH,BH,CX,AL
; Takes:	AL = character to print 
; Returns:	nothing
;
PROC	WriteCharAL	

	MOV	AH,0ah			; Interrupt Service Number 
	;MOV	BH,0			; Print to first page 
	XOR	BH,BH			; MOV BH,0
	MOV	CX,1			; Print only once
	INT	10h			; Call BIOS
	RET

ENDP


;
; Caution:	DO *NOT* PASS ARGUMENT IN 'AL'. PATENTLY BAD THINGS HAPPEN.
; Destroys: 	AH,BH,CX,AL
; Takes:	arg0 = character to print 
; Returns:	nothing
;
MACRO	WriteChar	char
	
	; BUG FIXED 6-21-99: Moved "MOV AL,..." to top, so that WriteChar
	; can be passed AH without printing 0ah. This tickled some VERY
	; obscure bugs. 
	MOV	AL,char			; Character to print goes in AL
	;MOV	AH,0ah			; Interrupt Service Number 
	;MOV	BH,0			; Print to first page 
	;XOR	BH,BH
	;MOV	CX,1			; Print only once
	;INT	10h			; Call BIOS
	CALL	WriteCharAL

ENDM
;
; WriteString - Write a string.
;     
; Destroys:	AX,DS,AH,DX
; Takes:	str - String to print. Must be a variable.
; Returns:	Nothing
;
MACRO	WriteString	string

	MOV	DX,OFFSET string
	CALL	WriteStringX

ENDM	WriteString	string

PROC	WriteStringX	

	MOV	AH,9h			; Service 9 - Write String 
	INT	21h			; Call BIOS
	RET

ENDP	WriteStringX	 

;
; ExitOK - Exit and return 0
;
; Destroys:	The entire program :)
; Takes:	Nothing
; Returns:	n/a
;
MACRO	ExitOK	

	MOV	AX,4c00h		; Service 4c (exit), return 00h.
	
	INT	21h			; Call a certian glorified interrupt
					; handler. 

ENDM	ExitOK

;
; ExitERR
; 
; Destroys:	The entire program. :)
; Takes:	Nothing
; Returns:	n/a
;
MACRO	ExitERR

	MOV	AX,4c01h		; Service 4c (exit), return 00h.
	INT	21h			; Call the G.I.H.
	
ENDM

MACRO	GetChar

	CALL GetCharX

ENDM
 
PROC	GetCharX

	MOV	ah,0			; Read Key
	XOR	ah,ah
	INT	16h			; Call BIOS
	RET

ENDP	GetCharX

;
; Start - Main Label
;
;
Start:
	MOV	AX,@data		; Load Data Segment 
	MOV	DS,AX			; Don't you just love Intel?
	
	ClrScr				; Gee, I feel like a *WEB DESIGNER* 
	
	WriteString	Copyright	

	WriteString	PressAnyKey	

	GetChar				; Press any key to continue
					; No, don't loose for the `ANY' key.
CtrlR:
BeginBaud:
	ClrScr

	WriteString	menu_Baud	

AskBaud:
	GetChar

	CMP 		AL,'1'		; Is it '1'
	JZ		Baud110		; If it is

	CMP		AL,'2'		; ditto
	JZ		Baud150

	CMP		AL,'3'		; see a pattern?
	JZ		Baud300

	CMP		AL,'4'
	JZ		Baud600

	CMP		AL,'5'
	JZ		Baud1200

	CMP		AL,'6'
	JZ		Baud2400

	CMP		AL,'7'
	JZ	 	Baud4800

	CMP		AL,'8'
	JZ		Baud9600

	CMP		AL,27
	JZ		EndProg

	JMP		SkipEndProg

EndProg:
	ExitOK					

SkipEndProg:

	MOV		AH,AL			; 
	
	WriteString	Invalid			; This Ain't Valid.

	JMP		AskBaud			; Ask the User Again

Baud110:
	MOV		[Baud],00000000b	; Save '110' to Baud.
	JMP		BeginParity	
Baud150:
	MOV		[Baud],0010000b		; s/110/150/
	JMP		BeginParity	
Baud300:	
	MOV		[Baud],0100000b		; 
	JMP		BeginParity	
Baud600:
	MOV		[Baud],0110000b
	JMP		BeginParity	
Baud1200:
	MOV		[Baud],1000000b
	JMP		BeginParity	
Baud2400:	
	MOV		[Baud],1010000b
	JMP		BeginParity	
Baud4800:	
	MOV		[Baud],1100000b
	JMP		BeginParity	
Baud9600:
	MOV		[Baud],1110000b

BeginParity:
	ClrScr
	WriteString	menu_Parity
AskParity:
	GetChar	

	CMP		AL,'1' 		; is it `1'?	
	JZ		NoParity	; then do this
	
	CMP		AL,'2'
	JZ		OddParity 

	CMP		AL,'3'
	JZ		EvenParity

	CMP		AL,27
	JZ		EndProg

	WriteString	Invalid
	JMP		AskParity

EndProg2:

	ExitOK		

NoParity:
	MOV		[Parity],00010000b
	JMP		BeginData	
OddParity:
	MOV		[Parity],00010000b
	JMP		BeginData	
EvenParity:
	MOV		[Parity],00011000b

BeginData:
	ClrScr
	WriteString	menu_DataBits
AskData:
	GetChar

	CMP 		AL,'1'
	JZ		Data7

	CMP		AL,'2'
	JZ		Data8

	CMP		AL,27
	JZ		EndProg4

	WriteString	Invalid	
	JMP		AskData

EndProg4:		; SPAGHETTI!! SPAGHETTI!
	ExitOK

Data7:
	MOV		[DataBits],00000010b
	JMP		BeginStop	
	
Data8:
	MOV		[DataBits],00000011b

BeginStop:
	ClrScr
	WriteString	menu_StopBits
AskStop:
	GetChar

	CMP		AL,'1'
	JZ		Stop1

	CMP		AL,'2'
	JZ		Stop2

	CMP		AL,27
	JZ		EndProg3

	WriteString	Invalid
	JMP		AskStop

Stop1:
	MOV		[StopBits],00000000b
	JMP		BeginPort 	
Stop2:
	MOV		[StopBits],00000100b
	JMP		BeginPort	
						
EndProg3:		;DYJLI?
	ExitOK

BeginPort:
	ClrScr
	WriteString	menu_Port
AskPort:
	GetChar

	CMP		AL,'1'
	JMP		Port0		; Old Habits Die Hard!

	CMP		AL,'2'
	JMP		Port1

	CMP		AL,'3'
	JMP		Port2

	CMP		AL,27
	JMP		EndProg3

	JMP		SCtrlR0
CtrlR0:
	JMP		CtrlR
SCtrlR0:
	CMP		AL,'4'
	JMP		Port3

	WriteString	Invalid
	JMP		AskPort

Port0:
	MOV		[Port],0
	JMP		StartComm
Port1:
	MOV		[Port],1
	JMP		StartComm
Port2:
	MOV		[Port],2
	JMP		StartComm
Port3:
	MOV		[Port],3
	JMP		StartComm
		

StartComm:
	ClrScr
	WriteString	StartCommMesg		

	XOR		AH,AH		; Set to zero
	MOV	 	AL,[StopBits]	; Combine Bit masks
	OR		AL,[DataBits]	; Combine 
	OR		AL,[Parity]	; Ditto	
	OR		AL,[Baud]	; Ditto
	MOV		DX,[Port]	; COM1:
	INT		14h		; Serial

CommLoop:

CheckDataIn:
	MOV		AH,03h		; 03h = Status
	INT		14h		; Serial
	CMP		AX,8h		; Data Availible
	JZ		DataIn		; Deal with it
CheckDataOut:	
	MOV		AH,01h		; 01h = Peek in Queue	
	INT		16h		; Keyboard
	JNZ		DataOut		; Deal with it

	JMP		CommLoop	; Repeat Loop
	
DataIn:	
	MOV		DX,[Port]	; Select Port
	MOV		AH,2h		; Recieve
	INT		14h		; Call BIOS Service: Serial
	TEST		AH,80H		; Error
	JNZ		SerialErrorIn	; Jump to Handler

DataOut:
	GetChar				; Hmm?
	CMP		Quoted,0	; Is it *NOT* quoted?
	JNZ		IfQuoted	 
	CMP		AL,18		; Is it ^R (reconfigure?)
	JZ		CtrlR0
	CMP		AL,5		; Is it ^E (flip echo)	
	JZ		CtrlE
	CMP		AL,22		; Is it ^V (quote?)
	JZ		CtrlV
	MOV		[ChStr],AL	; Write it there for printing
	CMP		AL,13		; Is it LF?
	JNZ		NoWriteCRLF	; If it isn't, then go to NoWriteCRLF
	WriteString	CRLF		; \n 
NoWriteCRLF:
	CMP		AL,8		; Backspace
	JNZ		NoWriteBackspace; Don't write backspace
	WriteString	BackSpace	; Write Backspace
NoWriteBackspace:
	CMP		AL,27 		; Is it escape?
	JZ 		EndItAll	; Then check if we've pressed it thrice 
	JMP		EchoSend
CtrlE:	
	NOT		[Echo]		; Flip Echo
CtrlV:
	INC		[Quoted]	; Increment If-Quoted 
	JMP		CommLoop	; Skip echoing it
IfQuoted:
	MOV		[Quoted],0
EchoSend:
	CMP		Echo,0
	JNZ		CommLoop	
RealEcho:
	WriteString	ChStr		; Otherwise Print It (ask not why)
	MOV		DX,0h		; Select COM1
					; Character is already in AL
	MOV		AH,1		; Serial Transmit
	INT		14h		; Serial Service
	TEST		AH,80h		; Test for error
	JNZ		SerialErrorOut	; Jump to Handler

	JMP		CommLoop
SerialErrorIn:		
	WriteString	ErrorIn
	JMP		CommLoop
SerialErrorOut:
	WriteString	ErrorOut
	JMP		CommLoop
EndItAll:
	ExitOK

	END		Start

