/*
**  Program:	    <chat.c>
**
**  Purpose:	    CHAT program for BYE-PC
**
**  Author:	    R.E. Starr, Jr.
**
**  Requirements:   <byexface.obj>
*/

#include    <stdio.h>
#include    <stdlib.h>
#include    <conio.h>
#include    <process.h>
#include    <ctype.h>
#include    <string.h>
#include    "byexface.h"

void wink();
void chat_loop();
int alert_sysop();

#define ON  1
#define OFF 0

#define BYE_VER 3	/* minimum version# required */
#define BYE_REV 0	/* minimum revision# required */

#define VER 1		/* chat version# */
#define REV 1		/* chat revision# */

#define ESC	27	/* escape */
#define CTRL_X	24	/* ctrl_x */
#define K_HOME	71	/* home key */
#define K_END	79	/* end key */


main(argc, argv)

 int argc;
 char *argv[];
    {
    int rtn;

    if (rtn = _bye_check(BYE_VER, BYE_REV))
	{
	printf("\nERROR: BYE-PC ");
	switch(rtn)
	    {
	    case 1:
		printf("is not loaded!\n");
		break;
	    case 2:
		printf("loaded is the wrong Version!\n");
		break;
	    case 3:
		printf("loaded is the wrong Revision!\n");
		break;
	    default:
		printf("returned invalid error code!\n");
		break;
	    }
	exit(1);
	}
    _bye_rxflush();		/* reset the rx queue  */
    printf("\nCHAT Version %1d.%-2.2d for BYE-PC\n", VER, REV);
    printf("[Use CTRL-X to Exit]\n\n");

    if (strcmpi("-S", argv[1]))
	if (!alert_sysop())
	    goto end;
    chat_loop();
    printf("\n[CHAT End]\n\n");

 end:
    _bye_rxflush();	    /* reset the receive queue */
    exit(0);
    }


/*
**  Function:	void chat_loop()
**
**  Paramters:	void
**
**  Purpose:	Keyboard char loop that echos chars to remote.
**
**  Return:	void
*/

void chat_loop()
 {
 int c;

 while(1)
    {
    if ((c = getch()) == NULL)	    /* scan code key? */
	c = getch();		    /* get scan code  */
    switch(c)
	{
	case ESC:
	case CTRL_X:		/* exit from chat keys */
	    return;
	case '\r':		/* do a cr/lf */
	    printf("\n");
	    break;
	case '\b':		/* do a backspace */
	    printf("\b \b");
	    break;
	default:		/* print the character */
	    printf("%c", (char)c);
	}
    }
 }


/*
**  Function:	void alert_sysop()
**
**  Paramters:	void
**
**  Purpose:	Rings the bell on local console to signal sys op.
**
**  Return:	1 = Sys/op on line
**		0 = No answer from sys/op
*/

int alert_sysop()
 {
 char name[65];
 int c, i, d, r;

 _bye_getname(name);
 printf("Operator page from %s: ", name);
 wink();
 for (i=0; i < 10; i++)
    {
    printf("\a");		    /* ring the bell */
    for (d = 0; d < 4096; d++)
	{
	if (!r)
	    wink();
	if (++r >= 64)		    /* rotation rate */
	    r = 0;
	if (kbhit())		    /* any keys pressed? */
	    {
	    if ((c = getch()) == NULL)	    /* scan code key? */
		c = getch();		    /* get scan code  */
	    switch(c)
		{
		case K_END:
		case K_HOME:
		    printf(".\n\n[Sys/Op on Line]: ");
		    return(1);
		case CTRL_X:
		    printf(".\n\n[CHAT Cancelled]\n");
		    return(0);
		}
	    }
	}
    printf(".");
    }
 printf("\n\nSorry, No Answer...\n");
 return(0);
 }


/*
**  Function:	void wink()
**
**  Paramters:	void
**
**  Purpose:	Simulates a rotating cursor.
**
**  Return:	void
*/

void wink()
 {
 static int state = 0;

 switch(state)
    {
    case 0:
	printf("|");
	break;
    case 1:
	printf("/");
	break;
    case 2:
	printf("-");
	break;
    default:
	state = 0;
	printf("\\");
    }
 state++;
 printf("\b");
 }

