/*
  German language messages for TAD v2.00.

  Waldemar Schultz.

  To create a version for your own language, copy this file to "lang-xx.c",
  where "xx" is your language identifier. Modify the strings as necessary,
  then add the appropriate defines to "tad.c". You may also want to change
  the place_str() and approx_time() functions.
*/


// 1234567890123456789012
// Fr, 31.12.99 23:59:59
#define MAX_TIME 22		// maximum length of time_fmt[1]

// 1234567890123456789012345678901234567890123456789
// 365 Tage, 23 Stunden, 59 Minuten und 59 Sekunden
#define MAX_DUR  49		// maximum length of calibration duration

// 12345678901234567890
// 12:00:00 Nachmittag
#define MAX_CLOCK 20		// maximum length of $T


// Default time format strings. There are three versions for each of normal,
// brief and concise.

char* time_fmt[]   = { "$D, $d. $M $Y  $+2C",
		       "$0D, $1b $+C",
		       "$Y$0m$0d$0H$0n$0s" };

char* approx_fmt[] = { "Es ist $a.",
		       "Es ist $a",
		       "$A" };

char* year_fmt[]   = { "$D, der $d. $M ist der $y. Tag im Jahr $Y.",
		       "Tag $y, Jahr $Y.",
		       "$y" };

char* week_fmt[]   = { "$w. Woche im Jahr $Y.",
		       "Woche $w, Jahr $Y.",
		       "$w" };


// Months of the year (normal, abbreviated).

char* monthname[2][12] = {
  { "Januar",    "Februar",  "Mrz",     "April",
    "Mai",       "Juni",     "Juli",     "August",
    "September", "Oktober",  "November", "Dezember" },

  { "Jan", "Feb", "Mr", "Apr", "Mai", "Jun",
    "Jul", "Aug", "Sep", "Okt", "Nov", "Dez" }
};

// The length of the longest month (abbreviated names are assumed to be equal).
int longest_monthname = 9;


// Days of the week (normal, abbreviated).

char* dayname[2][7] = {
  { "Sonntag",    "Montag",  "Dienstag", "Mittwoch",
    "Donnerstag", "Freitag", "Samstag" },

  { "So", "Mo", "Di", "Mi", "Do", "Fr", "Sa" }
};

int longest_dayname = 10;


// Ante-meridian and post-meridian (before and after noon).
char* ampm[] = { "Vormittag", "Nachmittag" };
int   longest_ampm = 10;


// Time and date separators (read from COUNTRY info).
char time_sep = ':';
char date_sep = '.';
int  date_ord = 1;	// 0 = m/d/y, 1 = d/m/y, 2 = y/m/d
int  time_hr  = 1;	// 0 = 12-hour, 1 = 24-hour


// Strings required for the approximate time function.

char* hourname[] = { "zwlf",
		     "eins",  "zwei",  "drei",   "vier",
		     "fnf",  "sechs", "sieben", "acht",
		     "neun",  "zehn",  "elf",
		     "zwlf", "ein" };

char* fives[]	 = { "uhr",
		     "fnf ",    "zehn ",        "viertel ",
		     "zwanzig ", "dreiviertel ", "halb ", "" };

char* rel[]	 = { "nach ", "vor ", "" };


// Exit code and brief duration characters.

// Day of week, century (19 or 20),
// years, months, weeks, days, hours, minutes, seconds.
// Order is important!
// If you change this, don't forget to change exit_help() and calc_help().
char exit_char[] = "DYyMwdhms";

// Duration words (plural and singular).
char* durname[7][2] = { { "Jahre",    "Jahr"    },
			{ "Monate",   "Monat"   },
			{ "Wochen",   "Woche"   },
			{ "Tage",     "Tag"     },
			{ "Stunden",  "Stunde"  },
			{ "Minuten",  "Minute"  },
			{ "Sekunden", "Sekunde" } };

// Duration message when zero.
char* zero_dur[] = { "Weniger als eine Sekunde",  // Calibration message
		     "Keine Systemzeit!" };       // Duration message

// Word to combine the second-last and last durations together.
char* and_str = "und";

// Thousands and decimal separators (read from COUNTRY info).
char thou_sep = '.';
char deci_sep = ',';
