* REPORT FORM: Header Option
*
* Call RL.EXE and proceed as usual with this exception: the page
* header must be defined as four lines of 60 characters each.
* Any characters will do; they will be changed anyway.  Then call
* the UDF before the REPORT FORM command.  Pass the four elements
* of the array; each will be a line of the header.  If you pass a
* null string, the result is a blank line.  If you pass an 
* invalid type (only a character string is valid), the line will 
* be untouched.  The UDF centers and pads the lines.
*
* Example main program to use the UDF()
* Author: Bao Hoang
*
*--Notes:  When the report form file is created, all lines of
*     the report form file header must be filled in with some
*     space holders.  For example, enter 60 X's for all lines
*     in the header of the report form.
*----------------------------------------------------------------
*--Sample output:
*
*--Before:
*
* Page No.     1
* 02/05/88
*       XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
*       XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
*       XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
*       XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
*
*
*--After:
*
* Page No.     1
* 02/05/88
*                              This is line 1
*                                  line 2
*                                 hjfhgjdf
*
*----------------------------------------------------------------
clear
use c:\source2\mems
set printer to bao.txt
declare arr[4]     && array of 4 elements (1 element/header line)
arr[1] = "This is line 1"
arr[2] = "line 2"
arr[3] = "hjfhgjdf"
arr[4] = " "           && blank out last line

if UDF("bao.frm",arr)
   report form bao to print
else
   ? "report form couldn't be modified!!"
endif
return


*--UDF to modify .FRM file on-the-fly
function udf
para fn,arr                  && fn = filename
                             && arr = array of header strings

private handle,;             && file handle
        offset,;             && offset of file to read
        tmp,;                && temporary work variable
        buffer,;             && buffer to hold offset value read
        string,;             && header string
        rv,;                 && return value (TRUE/FALSE)
        i,;                  && loop counter
        roffset              && rela offset

buffer = " "                 && init buffer

handle=FOPEN(fn,2)           && open the file

IF handle != -1
   FSEEK(handle,1965,0)         && move file pointer to pointer
   FREAD(handle,@buffer,1)      && read the offset pointer value
   offset = VAL(buffer)         && convert from string to numeric
   offset = 225 + offset - 1    && calculate real offset
   rv = .t.
   FOR i = 0 to 3
      IF TYPE("arr[I+1]") = "C"
         roffset = offset + (i * 61)
         string = arr[i+1]
         FSEEK(handle,roffset,0)      && move file pointer to
                                      &&    real offset
         tmp = (60 - LEN(string)) / 2 && center header
         string = SPACE(tmp)+string   &&   "     "
         tmp = 60 - LEN(string)       &&   "     "
         string = string + SPACE(tmp) &&   "     "
         FWRITE(handle,string,60)     && write it out
      ENDIF
   NEXT
   FCLOSE(handle)               && close the file
ELSE
   rv = .f.                     && couldn't open file
ENDIF
return(rv)                      && let's go home charlie
