
%NOLIST
;============================================================================
;
; CDROM.INC
; strucs/equs needed for cdrom-(driver) access
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================
%LIST

;constants
LOCKDOOR	EQU 1		;lock drive's door
UNLOCKDOOR	EQU 0		;unlock drive's door
HSGADR		EQU 0		;hsg-mode addressing
REDBOOK		EQU 1		;red-book addressing
COOKED		EQU	0		;cooked data-read
RAWDATA		EQU 1		;raw data-read

;IOCTL-input/output command-codes for cdrom drivers
IOCTL_DRVHDR	EQU 0300h	;return device-driver header
IOCTL_HEADLOC	EQU 0301h	;location of head
IOCTL_ERRSTAT	EQU 0303h	;error statistics
IOCTL_ACINFO	EQU 0304h	;audio channel info
IOCTL_RBYTES	EQU 0305h	;read drive bytes
IOCTL_DEVSTAT	EQU 0306h	;return device status
IOCTL_SECSIZE	EQU 0307h	;return sector size
IOCTL_VOLSIZE	EQU 0308h	;return volume size
IOCTL_MEDCHG	EQU 0309h	;media changed
IOCTL_DISKINFO	EQU 030Ah	;audio disk info
IOCTL_TRACKINFO	EQU 030Bh	;audio track info
IOCTL_QCINFO	EQU 030Ch	;audio Q-channel info
IOCTL_SCINFO	EQU 030Dh	;audio sub-channel info
IOCTL_UPC		EQU 030Eh	;UPC code
IOCTL_ASINFO	EQU 030Fh	;audio status info
IOCTL_EJECT		EQU 0C00h	;eject disk
IOCTL_LOCK		EQU 0C01h	;lock/unlock door
IOCTL_RESET		EQU 0C02h	;reset drive
IOCTL_ACCTRL	EQU 0C03h	;audio channel control
IOCTL_WBYTES	EQU 0C04h	;write device control string
IOCTL_CLOSE		EQU 0C05h	;close tray

;new commands for cdrom drivers
RDLONG	EQU 0080h	;read long
RDLONGP	EQU 0082h	;read long prefetch
SEEK	EQU 0083h	;seek
PLAY	EQU 0084h	;play audio
STOP	EQU 0085h	;stop audio
WRLONG	EQU 0086h	;write long
WRLONGV	EQU 0087h	;write long verify
RESUME	EQU 0088h	;resume audio

;structures

STRUC sCDDRVHDR				;extended device-driver header for cdrom-drivers
drvLink		dd ?			;pointer to next device-driver
drvAttrib	dw 0C800h		;attributes=character,open/close/rm,ioctl-i/o
drvStrat	dw ?			;strategy-routine entry point
drvIntr		dw ?			;interrupt-routine entry point
drvName		db "dev_name"	;device-name
cdRsvd		dw 0			;
cdDrive		db 0			;filled in by MSCDEX (has to be 0)
cdUnits		db ?			;number of units
ENDS sCDDRVHDR

STRUC sREDBOOK	;Red-Book address format
rbFrame	db 0	;frames (1/75 sec)
rbSec	db 0	;seconds
rbMin	db 0	;minutes
rbUnuse	db 0	;unused
ENDS sREDBOOK

STRUC sREADL				;request header for READ LONG
rlHdr		sREQHDR ?		;
rlAdrMode	db ?			;addressing mode (HSGADR or REDBOOK)
rlBuffer	dd ?			;pointer to transfer buffer
rlSize		dw ?			;number of sectors to read
UNION 
rlSector	dd ?			;sector number (HSGADR)
rlRedBook	sREDBOOK ?
;rlFrame		db ?			;sector address (REDBOOK) - frame (binary)
;rlSecond	db ?			; - second (binary)
;rlMinute	db ?			; - minute (binary)
;rlUnused	db ?			;
ENDS
rlDatMode	db ?			;data read mode (COOKED or RAWDATA)
rlIlSize	db ?			;interleave size
rlIlSkip	db ?			;interleave skip factor
ENDS sREADL

STRUC sTRACKINFO			;data returned by 'audio track info'
tiStart	dd 0				;start-address of track (red-book)
tiCtrl	db 0				;ctrl/adr bits
ENDS sTRACKINFO

;device status dword
RECORD rCDSTAT R0:19=0,RWS:1=0,DISKP:1=0,R1:1=0,RBA:1=0,AUD:1=0,PREF:1=1,R2:1=0,IL:1=0,PL:1=0,RW:1=0,RAW:1=0,LCK:1=0,DOOR:1=0
;R0,R1,R2	reserved
;RWS		1: supports R-W sub-channels, 0: does not
;DISKP		1: no disk in driver, 0: disk present
;RBA		1:supports both hsg- and re-book addressing, 0: only hsg-addressing
;AUD		1:supports audio channel manipulation
;PREF		1: supports prefetching requests
;IL			1:supports interleaving
;PL			1:data read and audio play, 0: data read only
;RW			1:read and write, 0: read only
;RAW		1:supports raw and cooked data read, 0: cooked only
;LCK		1:door unlocked, 0:door locked
;DOOR		1: door open, 0:door closed

STRUC sCDDATA		;data returned by MSCDEX 'device list'
cdUnit		db 0	;sub-unit of driver
cdDrvHdr	dw 0	;pointer to driver header
ENDS sCDDATA

;end of file 'CDROM.INC'

