/*
 * RPNSCRNS
 *
 * Get input characters.
 * Maintain the Help windows.
 *
 * 90.05.23 v3.0
 *	A new startup() routine can change the colors of the screens.
 *	Special-key tag changed from 0x7f00 to 0x1b00 --- this is consistent
 *	with the actual first byte of the extended scan code (no big deal).
 *	Optional savefile-output added.
 *	Help screens toggle from one to another.
 *	display() and related functions split out to display.c
 * 89.12.23
 */

#include <conio.h>
#include "rpn.h"
#include "rpnio.h"
#include "helpscrn.h"
#define FRAME_ALLOC
#include "display.h"
#include "debug.h"


static int orig_x, orig_y;

/*
 * h1_buffer saves the original screen under the Help windows.
 */
static char h1_buffer[ 2 * H_WIDTH * H_DEPTH ];


/* /////////////////////////////////////////////////////////////////////// */

#define NPOS (D_WIDTH+D_WIDTH+3)
#define FPOS (D_WIDTH+D_WIDTH+D_WIDTH+D_WIDTH+3)
#define OPOS (D_WIDTH+D_WIDTH+D_WIDTH+D_WIDTH+D_WIDTH+D_WIDTH+3)

void startup(void)
{
    unsigned color;

    /*
    | Save the original screen under the Help screens, just in case.
    */
    gettext(H_LEFT, H_TOP, H_RIGHT, H_BOTTOM, h1_buffer);

    /*
    | Discover the display window's colors, and use them.
    */
    D_NUM = (int)((char)0x8f & (frame[NPOS]));
    D_FTN = (int)((char)0x8f & (frame[FPOS]));
    D_OOPS = (int)((char)0x8f & (frame[OPOS]));
    color = frame[1];
    D_BKGND = (0x0070 & color);
    D_BORDER = (0x008f & color);
    textattr(color);

    if (0 >= TOP)	TOP = 6;	/** Ensure a legal	**/
    if (0 >= LEFT)	LEFT = 39;	/**  starting position.	**/

    orig_sl = scrolllock = *(char far *)ksp & SCROLL_LOCK;
    orig_x = wherex();
    orig_y = wherey();
}

/* /////////////////////////////////////////////////////////////////////// */

void shutdown(void) {
    window(1,1, 80,25);
    if (help_flag > 0)
        gotoxy(1, 24);          /* Put cursor at "almost" lower left. */
    else
        gotoxy(orig_x, orig_y); /* Reestablish original cursor position. */
}

/* /////////////////////////////////////////////////////////////////////// */

/*-------------------------------------------------------------------------*
| Cycle through the help screens.
*/

static char *scrntbl[3] = { h1_buffer, help1, help2 };

void toggle_help(void)
{
    if (++help_flag >= 3)	/** Cycle to next screen. **/
	help_flag = 0;

    puttext(H_LEFT, H_TOP, H_RIGHT, H_BOTTOM, (void *)scrntbl[ help_flag ]);
}

/* /////////////////////////////////////////////////////////////////////// */

/*---------------------------------------------------------------------*\
| Get keyboard input.							|
| Getch() returns one or two bytes from a PC keyboard (depending on	|
| the key, naturally).  If the first byte is 0, meaning that there	|
| IS a second byte, a value outside the normal character range is	|
| created by OR'ing the the second byte with 0x1b00.			|
|									|
| getkey() also cleans up the error-message line, because this is	|
| a convenient place to do it.						|
\* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int getkey(void)
{
    int c, k;

    DBG_FPRINTF((errfile,"\ngetkey:  scrolllock: %#x, *ksp: %#x, ",
	scrolllock, *(char far *)ksp));

    while (!kbhit() && (scrolllock == (*(char far *)ksp & SCROLL_LOCK)))
	;
    if (scrolllock != (k = *(char far *)ksp & SCROLL_LOCK)) {
	scrolllock = k;
	c = -1;
    } else
	if ( 0 == (c = getch()) ) {
            c = 0x1b00 | getch();
	}

    DBG_FPRINTF((errfile,"getkey: %#x, scroll %x\n", c, k));

    /* Put the original display border back, in case of error messages */
    puttext( LEFT, MSG_LINE, RIGHT, MSG_LINE,
		(void *)( frame + (6 * 2 * D_WIDTH) ) );
    window(S_LEFT, MSG_LINE, RIGHT, MSG_LINE);
    return c;
}

/* /////////////////////////////////////////////////////////////////////// */

void open_savefile(const char *fn)
{
    if ( 0 != (savefile = fopen(fn, "ab")) ) {
	setvbuf(savefile, NULL, _IOLBF, 161);
	fprintf(savefile,
		"%s\r\nFunction      Y-, X-;   LastX registers\r\n",
		version);
    } else
	prterr(fn, "can't open file.\n");
}

/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/

void close_savefile(void)
{
    fputs("\r\n", savefile);
    fclose(savefile);
    savefile = NULL;
}

/*\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
