/*
| ftns.h - prototypes and constants shared between ftns.c and process.c
|
| v3.0 90.05.14
|	Add some constants; prototypes for linear-regression functions
|	and gamma/factorial function; memory[] reduced to 50 (long double)
|	registers (from 100 (double) registers).
| 2:37:00  1/1/1990
*/
#ifndef FTNS_H
#define FTNS_H

#define MEMSIZE	100	/** # of available memory-storage locations **/

#define B0	90	/** Registers used for linear regressions **/
#define B1	91	/**   and linear interpolations.	  **/
#define SB0	92
#define TB0	93
#define SB1	94
#define TB1	95
#define SYX	96
#define R2	97
#define FR	98
#define COV	99

#define ONE	(long double)1.0
#define TWO	(long double)2.0

#define log_2		(double)(0.301029995663981198)
#define RAD_TO_DEG	(double)(57.2957795131)
#define DEG_TO_RAD	(double)(0.0174532925199432955)
#define Rad_Deg		RAD_TO_DEG

#define NUM_CONSTS  6
#define pi     	(double)(3.14159265358979324)
#define C	(double)299792.4562		/* km/second */
#define FC	(double)1797610211686.842	/* furlongs/fortnight */
#define PLANCK	((double)6.6261965e-34)		/* Joules/second */
#define AVOGADRO	((double)6.0221694e+23)		/* per mole */
#define EPSILON0	((double)8.854e-12)
			/* Farads/meter - permittivity of free space */

typedef struct {
	char *name;
	double val;
} const_struct;
typedef double C_DECL (*f_ptr)(double);
typedef void (*vf_ptr)(void);

#define UNARY	0
#define TRIG	1
#define I_TRIG	2
f_ptr  funct_1(char *name, int type);
vf_ptr funct_0(char *name);

double C_DECL frac(double x);
double C_DECL p10(double x);
double C_DECL fact(double x);

/** these prototypes shouldn't be needed... **/
double C_DECL dec_hrs(double h_ms);
double C_DECL hms(double dec_hr);
double C_DECL log2(double x);
double C_DECL squar(double x);

double C_DECL gamma(double x);
double C_DECL interpx(double y);
double C_DECL interpy(double x);

void clrreg(int first, int last);
void sumplus(void);
void summinus(void);
void geomean(void);
void harmean(void);
void mean(void);
void stddev(void);
void linreg(void);
void linstats(void);
void lin_coeffs(void);

void ru(void);
void rd(void);
void power(void);

void   shift_lastx(void);		/** utility ftns   **/
void   clear_state(char *label);	/** from process.c **/
void   push(void);
void   pop(void);
int    mul_ok(double, double, char *);

#if 0
/** these have been superceded by signal(SIGFPE...) **/
int    div_ok(double, double, char *);
int    add_ok(double, double, char *);
#define  sub_ok(a,b,c)		add_ok( (a), -(b), (c) )
#endif

#ifdef FTNS

int  stack_popped;		/** needed for undoing math errors   **/
int  math_error = 0;		/** records whether a math error has **/
				/** occurred, for cleaner recovery   **/
long double memory[ MEMSIZE ];
long double tmpLX;		/* used to restore lastX in case of error  */
int    stacklift;		/* All ftns except sum+, sum-, Enter, clX  */
				/*  enable stacklift for following numbers */
const_struct constants[] = {
	{"pi", pi},
	{"c", C},
	{"fc", FC},
	{"planck", PLANCK},
	{"avogadro", AVOGADRO},
	{"epsi", EPSILON0}
};

#else	/* !FTNS */

extern int  stack_popped;
extern int  math_error;
extern long double memory[ MEMSIZE ];
extern long double tmpLX;
extern int    stacklift;
extern const_struct constants[];

#endif	/* FTNS */

#endif  /* FTNS_H */
