/*
** printed circuit board autorouter, Copyright (C) Randy Nevin 1989, 1990.
**
** you may give this software to anyone, make as many copies as you like, and
** post it on public computer bulletin boards and file servers. you may not
** sell it or charge any fee for distribution (except for media and postage),
** remove this comment or the copyright notice from the code, or claim that
** you wrote this code or anything derived from it. you may modify the code as
** much as you want (please document clearly with comments, and maintain the
** coding style), but programs which are derived from this one are subject to
** the conditions stated here. i am providing this code so that people can
** learn from it, so if you distribute it, please include source code, not
** just executables. contact me to report bugs or suggest enhancements; i do
** not guarantee support, but i will make an effort to help you, and i want to
** act as a central clearing house for future versions. you should contact me
** before undertaking a significant development effort, to avoid reinventing
** the wheel. if you come up with an enhancement you consider particularly
** useful, i would appreciate being informed so that it can be incorporated in
** future versions. my address is: Randy Nevin, 24135 SE 16th PL, Issaquah,
** WA 98027, USA. this code is available directly from the author; just send a
** 360k floppy and a self-addressed floppy mailer with sufficient postage.
**
** HISTORY
** (name		date		description)
** ----------------------------------------------------
** randy nevin		2/1/89		initial version
** randy nevin		2/4/89		made retrace table driven, instead of
**					doubly-nested switch statements.
** randy nevin		2/4/89		changed dir from int to char (cut
**					storage for it in half).
** randy nevin		2/8/89		changed SetQueue and ReSetQueue to
**					give priority to goal nodes.
** randy nevin		2/11/89		don't output incremental search
**					results if stdout is redirected.
** randy nevin		2/11/89		released version 1.00
** randy nevin		5/7/89		added /N switch (don't sort
**					non-PRIORITY CONNECTs)
** randy nevin		12/27/89	removed code for compensating from
**					edge of hole to center of hole; just
**					approximate distance between centers
**					of two holes (simplify)
** randy nevin		12/29/89	added code to keep traces from
**					touching corner of a hole/via cell,
**					and to keep from drilling a via where
**					a corner of its cell touches a trace
** randy nevin		12/29/89	released version 1.10
*/

#include <stdio.h>
#include <stdlib.h>

#ifndef VMS
#include <io.h>
#endif

#include <time.h>
#include <string.h>
#include "cell.h"

/*
** if you run out of memory while routing large boards, there are two things
** you can do: (1) go into your config.sys file and disable everything you
** don't need. getting rid of things like ansi.sys, ramdisks, disk caches, and
** other terminate and stay resident (tsr) programs can free a lot of memory.
** (2) link the router, inspect the .map file, relink with the /CPARMAXALLOC:n
** switch, where n is calculated to allow for a near heap of about 5k. read
** the linker documentation before you do this. for me, the route.map file
** says the program needs 81EFh bytes. to this i add 1400h (5k) for a near
** heap to get 95EFh bytes or 95Fh paragraphs, which is 2399 decimal.
*/

int JustBoard = 0; /* need all data structures, not just the board */
int SortConnects = 1; /* default is to sort non-PRIORITY CONNECTs */
int Ntotal; /* total number of CONNECTs to make */

extern int Initialize( char *, int );
extern void Solve( void );
extern void Report( FILE * );

void main( int, char *[] );

void main ( argc, argv ) /* input board, route traces, output routed board */
	int argc;
	char *argv[];
	{
	char *self, *p;
	FILE *fp;
	long start, stop;

	printf( "Copyright (C) Randy Nevin, 1989, 1990. Version 1.10\n" );
	printf( "See source code for rights granted.\n\n" );
	start = time( NULL );
	self = argv[0];
	/* get rid of initial part of path */
	if ((p = strrchr( self, '\\' )) || (p = strrchr( self, ':' )))
		self = ++p;
	/* get rid of extension */
	if ((p = strrchr( self, '.' )) && !stricmp( p, ".EXE" ))
		*p = 0;
	if (argc == 4 && !stricmp( argv[1], "/n" )) {
		SortConnects = 0; /* don't do sorting */
		argv[1] = argv[2];
		argv[2] = argv[3];
		argc = 3;
		}
	else if (argc != 3) { /* need infile and outfile */
		fprintf( stderr, "usage: %s [/N] infile outfile\n", self );
		fprintf( stderr,
			" N = no sorting of non-PRIORITY CONNECTs\n" );
		exit( -1 );
		}
	if (!(fp = fopen( argv[2], "wb" ))) {
		fprintf( stderr, "can't open %s\n", argv[2] );
		exit( -1 );
		}
	Ntotal = Initialize( argv[1], 1 ); /* echo memory used */
	Solve();
	Report( fp );
	stop = time( NULL ) - start;
	printf( "time = %ld second%s\n", stop, (stop == 1) ? "" : "s" );
	exit( 0 );
	}
