/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                    
                             Demonstration Program 41                        
                                                                             
  Demonstrates wgettextwidth and wgettextheight functions.                   
                                                                             
  *** PROJECT ***                                                           
  This program requires the file WGT5_WC.LIB to be linked.                  
                                                                         
  *** DATA FILES ***                                                          
  LITTLE.WFN and MEDIUM.WFN must be in your executable directory.
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>

wgtfont medium;
wgtfont little;
char message[] = "This is the test string";

void main (void)
{
  printf ("WGT Example #41\n\n");
  printf ("Various fonts are measured using WGETTEXTWIDTH and WGETTEXTHEIGHT.\n");
  printf ("A keypress ends the program after sizes are reported.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  vga256 ();

  medium = wloadfont ("medium.wfn");
  little = wloadfont ("little.wfn");

  wtextcolor (15);

  wgtprintf (0, 0, NULL, "%s", message);
  wgtprintf (0, 8, NULL, "String width : %i pixels", wgettextwidth (message, NULL));
  wgtprintf (0, 16, NULL, "String height: %i pixels", wgettextheight (message, NULL));

  wgtprintf (0, 50, medium, "%s", message);
  wgtprintf (0, 66, NULL, "String width : %i pixels", wgettextwidth (message, medium));
  wgtprintf (0, 74, NULL, "String height: %i pixels", wgettextheight (message, medium));

  wgtprintf (0, 100, little, "%s", message);
  wgtprintf (0, 116, NULL, "String width : %i pixels", wgettextwidth (message, little));
  wgtprintf (0, 124, NULL, "String height: %i pixels", wgettextheight (message, little));

  getch ();
  wsetmode (3);
  wfreefont (little);
  wfreefont (medium);
}
