/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 14                         
									      
 Demonstrates string input,mouse cursor shape and speed, and                  
 wflashcursor, cursor coordinates (xc,yc).
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 NONE                                                                        
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>


void main(void)
{
  color palette[256];
  short i;
  short px,py,pbut;
  short oldmode;

  char *charlist=" ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_.";
	/* this is a list of all the possible characters you can enter
	   with wstring. If the character is not in the list, nothing will
	   happen and the cursor will remain in the same position. */

  char *yesno="YNyn";             /* used for yes/no answers only */

  char *string;                   /* A temporary string variable */

  printf ("WGT Example #14\n\n");
  printf ("This program demonstrates a few of the WGT text commands.\n");
  printf ("After answering each prompt, you will be able to move the mouse\n");
  printf ("as if it was a text cursor. Press a key to end the demo at that point.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  oldmode = wgetmode ();
  vga256 ();

  wcls (0);
  wtextcolor (15);
  wsetcolor (8);
  wtextbackground (7);
  wtexttransparent (TEXTFGBG);
  /* Both FG and BG are turned on so text will erase itself. */

  /* wstring allows strings to be entered using special keys such as
     the arrow keys, backspace, delete, insert, home and end, etc. */

  string = (char *)malloc (11);           /* remember to add one for
					     the null character. This
					     string is 10 chars long. */

  strcpy (string, " ");                   /* now make sure it is empty */

  curspeed = 2400;      /* type in a string, try using the special keys */

  wouttextxy (8, 0, NULL, "Type in a string: ");
  wstring (152, 0, string, charlist, 10);

  free (string);                         /* now free the memory */

  string = (char *)malloc (2);
  strcpy (string, " ");

  /* now try a yes or no answer, try letters other than {YNyn} */
  wouttextxy (8, 32, NULL, "Do you want to quit? ");
  wstring (176, 32, string, yesno, 1);
  free (string);

  wsetcursor (0, 7);                      /* now do something interactive */
  curspeed = 20;                          /* with the mouse */
  minit ();
  moff ();
  do {
    px = mouse.mx;
    py = mouse.my;
    pbut = mouse.but;
    xc = (px >> 3) << 3;        /* divide by 8 and multiply by 8 */
    yc = (py >> 3) << 3;        /* to make 8*8 squares */
    wflashcursor ();            /* Notice that the cursor uses wsetcolor */
    if (mouse.but != 0)
    {
      wsetcolor (rand () % 64);
      wline (0, 0, xc, yc);     /* do something with graphics as well */
    }
  } while (!kbhit ());
  mdeinit ();                   /* Deinitialize the mouse handler */

  wsetmode (oldmode);
}
