/* xcpivot.h                   freeware                   xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    : On a fraction.                                                     */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :  printf("%.0f/%.0f,",x.numer,x.denom);                             */
/* -------------------------------------------------------------------------- */
fraction jfpivotF(
pmatrix  m,
int      rowpivot,
int      colpivot,
int      colp,
int      rown_mns
)
{
fraction f;

fraction fn;
fraction fn_mns;

fraction fp;
fraction fpivot;

  fpivot.numer =  (*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL  ));
  fpivot.denom =  (*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL+1));

      fp.numer =  (*(m->pblock+rowpivot  *m->cols+colp*TWOCOL  ));
      fp.denom =  (*(m->pblock+rowpivot  *m->cols+colp*TWOCOL+1));

   fn_mns.numer = -(*(m->pblock+rown_mns *m->cols+colpivot*TWOCOL  ));
   fn_mns.denom =  (*(m->pblock+rown_mns *m->cols+colpivot*TWOCOL+1));

      fn.numer =  (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL  ));
      fn.denom =  (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL+1));


if(colpivot != colp)
{
      f = addF( multF(fpivot,fn), multF(fp,fn_mns));
}

if(colpivot == colp)
{
 (*(m->pblock+rown_mns *m->cols+colpivot*TWOCOL  )) = 0;
 (*(m->pblock+rown_mns *m->cols+colpivot*TWOCOL+1)) = 1;

 f = addF( multF(fpivot,fn), multF(fp,fn_mns));
}

  miniF(f);
/*
if(colp<colpivot)
{
printf("fn_mns[%d,%d]   %6.0f/%.0f fn[%d,%d]       %.0f/%.0f\n",
            rown_mns, colpivot,
        fn_mns.numer, fn_mns.denom,
            rown_mns,    colp,
            fn.numer,     fn.denom);
printf("fpivot[%d,%d]   %6.0f/%.0f fp[%d,%d]       %.0f/%.0f\n",
            rowpivot, colpivot,
        fpivot.numer, fpivot.denom,
            rowpivot,   colp,
            fp.numer,     fp.denom);

printf("\n\n(fpivot*fn) + (fp*fn_mns) = f = %.0f/%.0f\n\n",
        f.numer,      f.denom);
printf("\n\n(%.0f/%.0f)*(%.0f/%.0f) + (%.0f/%.0f)*(%.0f/%.0f);  \n\n",
         fpivot.numer, fpivot.denom,
             fn.numer,     fn.denom,
             fp.numer,     fp.denom,
         fn_mns.numer, fn_mns.denom);

     printmF(m);
getchar();
}
*/

 return(f);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :  On a row.                                                         */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void jrpivotF(
pmatrix  m,
int      rowpivot,
int      colpivot,
int      rown_mns
)
{
     int colp;
fraction f;

    if((*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL)))
     {
       for(colp = (m->cols/2)-1 ; colp > -1 ; colp--)
        {
         f = jfpivotF(m, rowpivot, colpivot, colp, rown_mns);

         (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL  )) = f.numer;
         (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL+1)) = f.denom;

        }
     }

      frowminiF(m,rown_mns);
      growminiF(m,rown_mns);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :  On a row.                                                         */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void jcpivotF(
pmatrix  m,
int      rowpivot,
int      colpivot
)
{
int      rown_mns;

      for(rown_mns = rowpivot-1; rown_mns > -1 ; rown_mns--)
        {
          while( !(*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL)) &&
                  (colpivot < (m->cols/2)-1)
               )
               {
                colpivot++;
               };

         jrpivotF(m, rowpivot, colpivot,rown_mns);
        }
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void jdpivotF(
pmatrix  m
)
{
int      rowpivot;

     for(rowpivot = (m->rows)-1; rowpivot  ; rowpivot--)
     {
      jcpivotF(m, rowpivot,0);
     }
}


