include system.inc
include src\opt1.inc
include src\dll.inc
include dll.inc

;USE_ZLIB equ 1

include src\dlltab.inc

include dll_le.asm  ;LE-EXE loading code

ifdef USE_ZLIB
uncompress  proto :dword,:dword,:dword,:dword    ; zlib decompression.
endif

.data?
dllhdr dllhdrs <?>                ; DLL file header
ofs1   dd ?                       ; ..
ofs2   dd ?                       ; used for decompression
temp1  dd ?                       ; can't be local :-|

.code

dll_load proc,fn:dword
  local fh:word,hnd:dword,buffer:dword,fixup:dword
  local buf2:dword    ; used during decompression

  xor   eax,eax
  pushad
; initialize local variables. We need to, since the "bad:" handling
; "frees" the various resources if they are non-zero..
  mov   fh,0                           ; file handle
  mov   buffer,0                       ; LE image buffer
  mov   fixup,0                        ; fixup buffer
  mov   hnd,0                          ; DLL handle
  mov   buf2,0                         ; decompression buffer

  callp malloc,sizeof hnds             ; get mem for a DLL handle
  test  eax,eax                        ; error?
  jz    bad                            ; if error, split

; initialized DLL handle struct
  mov   hnd,eax                        ; save handle
  mov   edx,eax
  mov   [edx].hnds.exportlst,0         ; ..
  mov   [edx].hnds.exportsiz,0         ; ..
  mov   [edx].hnds.leimg,0             ; ..
  mov   [edx].hnds.lesiz,0             ; like, zero stuff

  callp open,fn,O_BINARY or O_RDONLY   ; open the file
  cmp   eax,ERROR                 ; ..
  je    bad                       ; if error, split
  mov   fh,ax                     ; save file handle

  callp read,fh,offset dllhdr,sizeof dllhdrs     ; read DLL header
  cmp   eax,sizeof dllhdrs        ; read size==wanted size?
  jne   bad                       ; if not, split
  cmp   dllhdr.sig,QDLL_SIG       ; got the right signature?
  jne   bad                       ; if not, split

; alloc mem, load in the DLL image
  mov   eax,dllhdr.imagesize      ; PHYS. size on disk
  add   eax,dllhdr.bsssize        ; expand to logical size (in ram)
  mov   [edx].hnds.lesiz,eax      ; do we really need lesiz??
  callp calloc,eax,1              ; alloc mem (calloc so the mem is cleared)
  test  eax,eax                   ; error?
  jz    bad                       ; if error, split
  mov   buffer,eax                ; save buffer
  mov   [edx].hnds.leimg,eax      ; save it in handle, too

  test  dllhdr.flags,QF_COMPRESSED; is the DLL compressed?
  jz    @@not_compressed          ; if not, proceed to normal code

ifdef USE_ZLIB                    ; compression supported?
  ; okay. The DLL is compressed. Get memory for decompression buffer (actually
  ; compressed data), read in the compressed DLL, and decompress it.
  mov   eax,dllhdr.compressedsize ; alloc temp. decompression buffer
  callp calloc,eax,1              ; get memory
  test  eax,eax                   ; error?
  jz    bad                       ; if error, split
  mov   buf2,eax                  ; save decompression buffer

  callp read,fh,buf2,dllhdr.compressedsize ; read compressed image
  cmp   eax,dllhdr.compressedsize ; read size==wanted size?
  jne   bad                       ; if not, split

  mov   eax,dllhdr.imagesize      ; base size
  add   eax,dllhdr.bsssize        ; +BSS size
  mov   temp1,eax                 ; =total size (dll needs it)

  mov   ofs1,offset temp1                ; NEED to use offsets to the real
  mov   ofs2,offset dllhdr.compressedsize; functions, or you will get BAD crashes..

  push  ecx                       ; uncompress trashes EAX,ECX and EDX. We don't
  push  edx                       ; need EAX after this, so don't push it.
  callp uncompress,buffer,ofs1,buf2,ofs2 ;uncompress it
  pop   edx                       ; ..
  pop   ecx                       ; restore regs

  callp free,buf2                 ; free decompression buffer
  mov   buf2,0                    ; invalidate decompression buffer
  jmp   @@decompress_done         ; skip other code

else                              ; if compression NOT supported
  jmp   bad
endif

@@not_compressed:

  callp read,fh,buffer,dllhdr.imagesize
  cmp   eax,dllhdr.imagesize      ; ..
  jne   bad                       ; split if error
  ; do relocations here
@@decompress_done:
  mov   eax,dllhdr.numrelocs      ; size of reloc info
  callp malloc,eax                ; get memory for relocation stuff
  test  eax,eax                   ; ..
  jz    bad                       ; split if error
  mov   fixup,eax                 ; save relocation stuff

  callp read,fh,fixup,dllhdr.numrelocs ; read the fixups
  cmp   eax,dllhdr.numrelocs      ; ..
  jne   bad                       ; split if read size!=wanted size
  callp close,fh                  ; close the file
  mov   fh,0                      ; invalidate file handle

  test  dllhdr.flags,QF_NEWFIXUP
  jz    bad                      ; we only support the new fixups

comment ~
  callp le_fixup1,fixup,buffer    ; store "load offsets" for use with le_fixup()
  cmp   eax,ERROR                 ; ..
  je    bad                       ; split if error
  callp le_fixup,fixup,buffer     ; do the actual fixup
  cmp   eax,ERROR                 ; ..
  je    bad                       ; split if error
~
; process the fixups
  mov   ecx,dllhdr.numrelocs
  shr   ecx,3                     ; div by 8 to get number of relocs

  pushad

  mov   esi,fixup
  mov   edi,buffer
@@fixup_loop:
  mov   ebx,[esi]       ; location
  mov   eax,[esi+4]     ; fixup value
  add   eax,edi

  mov   edx,edi
  add   edx,ebx
  mov   [edx],eax

  add   esi,8

  dec   ecx
  jnz   @@fixup_loop

  popad


  callp free,fixup                ; free fixups (not needed anymore)
  mov   fixup,0                   ; invalidate fixup block

  mov   eax,dllhdr.entrypoint     ; ..
  add   eax,buffer                ; EAX=offset of dll_init()
;call dll_init()
  callp eax,DLL_VERSION,edx,offset __dll_codetable,offset __dll_datatable
  cmp   eax,ERROR                 ; ..
  je    bad                       ; split if error

  popad
  mov   eax,hnd
  ret

bad:
  .if fh
    callp close,fh
  .endif
  .if hnd
    mov ebx,hnd
    mov eax,[ebx].hnds.exportlst
    .if eax
      callp free,eax
    .endif
    callp free,ebx
  .endif
  .if buffer
    callp free,buffer
  .endif
  .if fixup
    callp free,fixup
  .endif
  .if buf2
    callp free,buf2
  .endif
  popad
  dec eax ;ERROR
  ret
dll_load endp

dll_unload proc uses edx,hnd:dword
  mov   edx,hnd
  callp free,[edx].hnds.exportlst   ;Free export list
  callp free,[edx].hnds.leimg       ;Free LE-EXE image
  callp free,edx                    ;Free handle
  xor   eax,eax
  ret
dll_unload endp

dll_import_nam proc,hnd:dword,nam:dword
  pushad
  mov  eax,hnd
  mov  ebx,[eax].hnds.exportlst
  mov  ecx,[eax].hnds.exportsiz  ;# elements
  test ebx,ebx
  jz   bad
  test ecx,ecx
  jz   bad
@@:
  callp stricmp,dptr[ebx],nam
  test eax,eax
  je ok1
  add ebx,8
  dec ecx
  jnz @b
  jmp bad  ;not found
ok1:
  mov eax,[ebx+4]
  mov [esp].callstruct._eax,eax  ;Save EAX
  popad
  ret  
bad:
  popad
  mov eax,ERROR
  ret
dll_import_nam endp

dll_import_idx proc,hnd:dword,idx:dword
  pushad
  mov  eax,hnd
  mov  ebx,[eax].hnds.exportlst   ; get export list
  mov  ecx,[eax].hnds.exportsiz   ; # elements
  dec  ecx                        ; since idx is zero-based, exportsiz isn't
  jc   bad                        ; overflow?
  cmp  ecx,idx                    ; ..
  jb   bad                        ; requesting element>loaded elements?
  test ebx,ebx                    ; export list 0?
  jz   bad

  mov  ecx,idx
  shl  ecx,3                      ; mul by 8
  add  ecx,ebx
  mov  eax,[ecx+4]                ; get function

  mov [esp].callstruct._eax,eax  ;Save EAX
  popad
  ret  
bad:
  popad
  mov eax,ERROR
  ret
dll_import_idx endp

dll_import_hint proc,hnd:dword,nam:dword,hint:dword
  pushad
  mov   eax,hnd
  mov   ebx,[eax].hnds.exportlst  ; get export list
  mov   ecx,[eax].hnds.exportsiz  ; # elements
  dec   ecx                       ; since idx is zero-based, exportsiz isn't
  jc    bad                       ; overflow?
  cmp   ecx,hint                  ; ..
  jb    dont_hint                 ; requesting element>loaded elements?
  test  ebx,ebx                   ; export list 0?
  jz    bad

  mov   ecx,hint
  shl   ecx,3                     ; mul by 8
  add   ecx,ebx

  callp stricmp,dptr[ecx],nam     ; compare name
  test  eax,eax                   ; is it the right one?
  je    ok1

; the hinted function wasn't the one. Search the whole list.
dont_hint:
  callp dll_import_nam,hnd,nam    ; will return ERROR if bad, so jump to ok2
  jmp   ok2

ok1:
  mov  eax,[ecx+4]                ; get function
ok2:
  mov [esp].callstruct._eax,eax   ; save EAX on PUSHAD'ed regs
  popad                           ; get back the regs (including the new EAX)
  ret                             ; return
bad:
  popad
  mov eax,ERROR
  ret
dll_import_hint endp

dll_call proc,hnd:dword,nam:dword,va:vararg
  callp dll_import_nam,hnd,nam
  cmp eax,ERROR
  jz bad
  pop ebp  ;EBP was pushed!
  jmp eax  ;JMP to DLL PROC (which will do the RETurning)
bad:
;  mov eax,ERROR ; not necessary, EAX already = ERROR
  ret
dll_call endp

dll_export proc,hnd:dword,sym:dword,off:dword
  pushad
  mov edx,hnd
  mov ebx,[edx].hnds.exportlst
  mov ecx,[edx].hnds.exportsiz    ; get # of exported symbols
; figure the size we need to realloc() to.
  inc ecx                         ; gonna add one new symbol
  shl ecx,3                       ; *8 (size of export list)

  callp realloc,ebx,ecx
  test eax,eax
  jz bad
  mov ebx,eax
  mov [edx].hnds.exportlst,ebx
  add ebx,ecx
  sub ebx,8    ;move back to last element
  mov eax,sym
  mov [ebx],eax
  mov eax,off
  mov [ebx+4],eax
  inc [edx].hnds.exportsiz
  popad
  xor eax,eax
  ret
bad:
  popad
  mov eax,ERROR
  ret
dll_export endp

dll_export_list proc,hnd:dword,list:dword,num:dword
  pushad
  mov  edx,hnd
  mov  ebx,[edx].hnds.exportlst
  mov  ecx,[edx].hnds.exportsiz   ; get # of exported symbols
; figure the size we need to realloc() to.
  add  ecx,num                    ; bump the counter
  shl  ecx,3                      ; *8 (size of export list)

  callp realloc,ebx,ecx           ; resize the list
  test eax,eax
  jz   bad                        ; split if error

  mov  [edx].hnds.exportlst,eax   ; store (possibly) new pointer
  mov  ebx,eax                    ; EBX=(possibly) new pointer

  mov  esi,list                   ; copy from the user list
  mov  edi,[edx].hnds.exportsiz   ; get # of exports
  shl  edi,3                      ; multiply by 8
  add  edi,eax                    ; should point to the first of
                                  ; the new entries now, hopefully :)

  mov  ecx,num
  add  [edx].hnds.exportsiz,ecx
  shl  ecx,3

  copyECX

  popad
  xor  eax,eax
  ret
bad:
  popad
  mov eax,ERROR
  ret
dll_export_list endp

dll_numexports proc uses edx,hnd:dword
  mov   edx,hnd
  mov   eax,[edx].hnds.exportsiz
  ret
dll_numexports endp

end
