/**********************************************************/
/* File Id.                  Vgascan.C                    */
/* Author.                   Stan Milam.                  */
/* Date Written.             25 Sep 89.                   */
/*                                                        */
/*          (c) Copyright 1989-90 by Stan Milam           */
/*                                                        */
/* Comments: Used to set the number of scan lines used for*/
/* character on the display screen if a VGA is in use.    */
/*                                                        */
/* Arguments:                                             */
/*      0 = 200 scan lines (CGA style ughh!)              */
/*      1 = 350 scan lines (EGA style)                    */
/*      3 = 400 scan lines (VGA style)                    */
/**********************************************************/

#include <dos.h>
#include "pcwproto.h"

void set_vga_scan_lines(int arg) {

   union REGS regs;
   int   mxr,mxc;

   chk_video_state(&mxr,&mxc);         /* Initialize: make sure */
   if (_adaptor == VGA) {              /* Check for VGA to do this */
      switch(arg) {                    /* Verify our arguments */
         case 0 :
         case 1 :
         case 2 : break;
         default: return;
      }
      regs.h.ah = 0x12;                /* BIOS function 12 sub-function 30 */
      regs.h.al = (char) arg;
      regs.h.bl = 0x30;
      int86(0x10,&regs,&regs);
      if (_monitor == COLOR) vsetmode(3);
      else vsetmode(7);
/*      (_monitor == COLOR) ? vsetmode(3) : vsetmode(7);*/ /* Reset video mode */
   }
}
