/***********************************************************/
/* File Id.                  Vcls.C                        */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/19/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/*          (c) Copyright 1989-90 by Stan Milam            */
/*                                                         */
/* Comments:  This routine will clear the text screen via  */
/* ROM BIOS.  It will call getvmode, which also calls ROM  */
/* BIOS, to make sure we are in text mode before clearing  */
/* the screen.  getvmode() will also tell us how wide the  */
/* text screen is.  If we are not in a text mode then      */
/* nothing will happen and the function will return NULL.  */
/* However, if the screen is in text mode it will be       */
/* and the function will return 1.                         */
/***********************************************************/

#include <dos.h>
#include "pcwproto.h"

#define NULL 0

void vcls(void)  {

    union REGS regs;
    int   mx_rows, mx_cols;

    if (chk_video_state(&mx_rows, &mx_cols)) {
       regs.x.ax = 0x600;                  /* Scroll up entire window */
       regs.x.bx = 0x0700;                 /* Light grey on Black */
       regs.x.cx = 0;                      /* Upper corner */
       regs.h.dh = (char) (mx_rows - 1);   /* Bottom row */
       regs.h.dl = (char) (mx_cols - 1);   /* Right most column */
       int86(0x10,&regs,&regs);            /* Call BIOS to clear screen */
       set_cursor_pos(1,1);                /* Locate cursor at home pos */
    }
}
