#*************************************************************
#* File Id.                   TCPCW.MAK                      *
#*                                                           *
#*           (c) Copyright 1989-90 by Stan Milam             *
#*                                                           *
#* Comments: This is the make file for the Turbo C           *
#* compiler for PC Windows.  When building the library set   *
#* compiler command line options and the library name.  The  *
#* naming convention I use is:                               *
#*    cc PCW mm   where cc is a two letter symbolic for the  *
#* compiler, PCW is for PC Windows, and mm is a two letter   *
#* mnumonic for the memory model.  Example:                  *
#*   mspcwas - Microsoft compiler, pcw, medium memory model. *
#*   tcpcwml - Turbo C, large memory model.                  *
#*   pcpcwmm - Power C, medium memory model.                 *
#*                                                           *
#* Command line invocation:                                  *
#*    make -ftcpcw.mak -Dmodel=[ms, mm, mc, mh, or ml]       *
#*                                                           *
#* Example:                                                  *
#*    make -ftcpcw.mak -Dmodel=ms                            *
#*                                                           *
#* Result is source is compiled using small memory model and *
#* the resulting library name is TCPCW(MS).LIB               *
#*************************************************************

CC=tcc
MASM=masm
options=-c -$(model) -K -w -O -G -I..\pcw
library=..\tcpcw$(model).lib
header=..\pcw\pcw.i ..\pcw\pcwproto.h

LOBJ1 = mstscrn.obj pmenu.obj lmenu.obj cursor.obj qprintf.obj wframe.obj \
        wexplode.obj wprintf.obj wputs.obj pushpop.obj reorder.obj \
        hideshow.obj wtitle.obj wblkwrt.obj clr_wnd.obj qbox.obj sound.obj \
        swait.obj rest.obj qfill.obj vcls.obj qhchar.obj pcwkern.obj

LOBJ2 = vgetmode.obj qputchar.obj qvchar.obj qputs.obj mouse.obj msintr.obj\
        chgattr.obj keybd.obj attr.obj scroll.obj wscroll.obj msdelay.obj \
        qblkwrt.obj wprints.obj pcwexit.obj fload.obj vgascan.obj farcopy.obj \
        msint24a.obj int24c.obj palette.obj getchars.obj fonts.obj plmenu.obj \
        tmenu.obj msint29a.obj int29c.obj

$(library): $(LOBJ1) $(LOBJ2)
     del $(library)
     tlib /c /e$(library) @..\pcw\tcpcw.rsp

mstscrn.obj:   ..\pcw\mstscrn.asm
     $(MASM) /mx  ..\pcw\mstscrn,mstscrn,nul,nul

msdelay.obj:   ..\pcw\msdelay.asm
     $(MASM) /mx  ..\pcw\msdelay,msdelay,nul,nul

msint24a.obj:  ..\pcw\msint24a.asm
     $(MASM) /mx  ..\pcw\msint24a,msint24a,nul,nul

msint29a.obj:  ..\pcw\msint29a.asm
     $(MASM) /mx  ..\pcw\msint29a,msint29a,nul,nul

msintr.obj:    ..\pcw\msintr.asm
     $(MASM) /mx  ..\pcw\msintr,msintr,nul,nul

farcopy.obj:   ..\pcw\farcopy.c     $(header)
     $(CC)   $(options) ..\pcw\farcopy.c

pcwkern.obj:   ..\pcw\pcwkern.c     $(header)
     $(CC)   $(options) ..\pcw\pcwkern.c

qprintf.obj:   ..\pcw\qprintf.c     $(header)
     $(CC)  $(options) ..\pcw\qprintf.c

qputs.obj:     ..\pcw\qputs.c       $(header)
     $(CC)  $(options) ..\pcw\qputs.c

qblkwrt.obj:   ..\pcw\qblkwrt.c     $(header)
     $(CC)  $(options) ..\pcw\qblkwrt.c

qputchar.obj:  ..\pcw\qputchar.c    $(header)
     $(CC)  $(options) ..\pcw\qputchar.c

qfill.obj:     ..\pcw\qfill.c       $(header)
     $(CC)  $(options) ..\pcw\qfill.c

pushpop.obj:   ..\pcw\pushpop.c     $(header)
     $(CC)  $(options) ..\pcw\pushpop.c

qvchar.obj:    ..\pcw\qvchar.c      $(header)
     $(CC)  $(options) ..\pcw\qvchar.c

qhchar.obj:    ..\pcw\qhchar.c      $(header)
     $(CC)  $(options) ..\pcw\qhchar.c

reorder.obj:   ..\pcw\reorder.c     $(header)
     $(CC)  $(options) ..\pcw\reorder.c

swait.obj:      ..\pcw\swait.c      $(header)
     $(CC)  $(options) ..\pcw\swait.c

rest.obj:       ..\pcw\rest.c       $(header)
     $(CC)  $(options) ..\pcw\rest.c

qbox.obj:      ..\pcw\qbox.c        $(header)
     $(CC)  $(options) ..\pcw\qbox.c

wframe.obj:    ..\pcw\wframe.c      $(header)
     $(CC)  $(options) ..\pcw\wframe.c

wexplode.obj:  ..\pcw\wexplode.c    $(header)
     $(CC)  $(options) ..\pcw\wexplode.c

wtitle.obj:    ..\pcw\wtitle.c      $(header)
     $(CC)  $(options) ..\pcw\wtitle.c

hideshow.obj:  ..\pcw\hideshow.c    $(header)
     $(CC)  $(options) ..\pcw\hideshow.c

vcls.obj:      ..\pcw\vcls.c        $(header)
     $(CC)  $(options) ..\pcw\vcls.c

vgetmode.obj:   ..\pcw\vgetmode.c   $(header)
     $(CC)  $(options) ..\pcw\vgetmode.c

mouse.obj:     ..\pcw\mouse.c       $(header)
     $(CC)  $(options) ..\pcw\mouse.c

cursor.obj:    ..\pcw\cursor.c      $(header)
     $(CC)  $(options) ..\pcw\cursor.c

sound.obj:     ..\pcw\sound.c       $(header)
     $(CC) $(options) ..\pcw\sound.c

wprintf.obj:   ..\pcw\wprintf.c     $(header)
     $(CC) $(options) ..\pcw\wprintf.c

wputs.obj:     ..\pcw\wputs.c       $(header)
     $(CC) $(options) ..\pcw\wputs.c

wblkwrt.obj:   ..\pcw\wblkwrt.c     $(header)
     $(CC) $(options) ..\pcw\wblkwrt.c

wprints.obj:   ..\pcw\wprints.c     $(header)
     $(CC) $(options) ..\pcw\wprints.c

clr_wnd.obj:   ..\pcw\clr_wnd.c     $(header)
     $(CC) $(options) ..\pcw\clr_wnd.c

wscroll.obj:   ..\pcw\wscroll.c     $(header)
     $(CC) $(options) ..\pcw\wscroll.c

scroll.obj:    ..\pcw\scroll.c      $(header)
     $(CC) $(options) ..\pcw\scroll.c

attr.obj:      ..\pcw\attr.c        $(header)
     $(CC) $(options) ..\pcw\attr.c

chgattr.obj:   ..\pcw\chgattr.c     $(header)
     $(CC) $(options) ..\pcw\chgattr.c

keybd.obj:     ..\pcw\keybd.c       $(header)
     $(CC) $(options) ..\pcw\keybd.c

getchars.obj:  ..\pcw\getchars.c    $(header)
     $(CC) $(options) ..\pcw\getchars.c

pmenu.obj:     ..\pcw\pmenu.c       $(header) ..\pcw\menu.h
     $(CC) $(options) ..\pcw\pmenu.c

tmenu.obj:     ..\pcw\tmenu.c       $(header) ..\pcw\menu.h
     $(CC) $(options) ..\pcw\tmenu.c

lmenu.obj:     ..\pcw\lmenu.c       $(header) ..\pcw\menu.h
     $(CC) $(options) ..\pcw\lmenu.c

plmenu.obj:     ..\pcw\plmenu.c     $(header) ..\pcw\menu.h
     $(CC) $(options) ..\pcw\plmenu.c

pcwexit.obj:   ..\pcw\pcwexit.c     $(header)
     $(CC) $(options) ..\pcw\pcwexit.c

fload.obj:     ..\pcw\fload.c       $(header)
     $(CC) $(options) ..\pcw\fload.c

fonts.obj:     ..\pcw\fonts.c       $(header)
     $(CC) $(options) ..\pcw\fonts.c

vgascan.obj:   ..\pcw\vgascan.c     $(header)
     $(CC) $(options) ..\pcw\vgascan.c

int24c.obj:    ..\pcw\int24c.c      $(header)
     $(CC) $(options) ..\pcw\int24c.c

int29c.obj:    ..\pcw\int29c.c      $(header)
     $(CC) $(options) ..\pcw\int29c.c

palette.obj:   ..\pcw\palette.c     $(header)
     $(CC) $(options) ..\pcw\palette.c
