
/***********************************************************/
/* File Id.                  Qvchar.C                      */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/09/88.                     */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Date Last Modified.                                     */
/* Comments:  This routine is called to write a character  */
/* vertically on the screen repeatedly.                    */
/***********************************************************/

#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

int qvchar(int row, int col, int fcolor, int bcolor, char ch, int count) {

   int far  *scrnptr;
   unsigned chrattr;
   unsigned offset, scrnseg;
   int mx_rows, mx_cols;
   int page, pagesize;

   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);

   page     = getpage();
   pagesize = getpagesize();
   scrnseg  = getscrnseg();
   chrattr  = MK_ATTR(fcolor,bcolor) | ch;
   offset   = MK_SCRNOFF(row, col);
   scrnptr  = (int far *) MK_FP(scrnseg,offset);
   Tvertchar(count, chrattr, scrnptr);
   return(1);
}
