
/************************************************************/
/* File Id.                  Qprintf.C                      */
/* Author.                   Stan Milam.                    */
/* Date Written.             11/06/88.                      */
/* Date Last Modified.                                      */
/*                                                          */
/*            (c) Copyright 1989-90 by Stan Milam           */
/*                                                          */
/* Comments:                                                */
/************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include "pcwproto.h"
#define wrkstr PCWRKSTR

extern char wrkstr[];

int qprintf(int row, int col, int fcolor, int bcolor, char *format, ...)  {

   static va_list arglist;

   va_start(arglist, format);
   vsprintf(wrkstr, format, arglist);
   return(qputs(row, col, fcolor, bcolor, wrkstr));
}

/***********************************************************/
/*                          Qvprintf                       */
/*                                                         */
/* This function prints a formated string vertically on the*/
/* screen.                                                 */
/***********************************************************/

int qvprintf(int row, int col, int fcolor, int bcolor, char *format, ...) {

   va_list arglist;

   va_start(arglist, format);
   vsprintf(wrkstr, format, arglist);
   return(qvputs(row, col, fcolor, bcolor, wrkstr));
}
