/***********************************************************/
/* File Id.                  Pcwexit.C.                    */
/* Author.                   Stan Milam.                   */
/* Date Written.             09/08/89.                     */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Comments: Routine to remove all active windows when a   */
/* program terminates if PCW was initialized by default or */
/* an explicit pcwinit(AUTOEXIT) was made.  This routine   */
/* can be circumvented by making an explicit call to       */
/* pcwinit() with a value of NOEXIT before any other PCW   */
/* function is called.  This routine is invoked either     */
/* explicitly by the application program or automatically  */
/* by the ANSI standard function atexit().                 */
/***********************************************************/

#include <stdio.h>
#include "pcwproto.h"

void _pcw_exit(void) {

   WNDPTR *wnd;

   wnd = get_active_wnd();
   while (wnd != NULL) {
       wnd = wpop(wnd);
       wnd = get_active_wnd();
   }
}
