/**********************************************************/
/* Program-Id.               MousDemo.C                   */
/* Date Written.             07/03/89.                    */
/* Author.                   Stan Milam.                  */
/*                                                        */
/* Comments:  Originally this was test code for the mouse */
/* routines.  Have taken it and cleaned it up and added   */
/* some new function calls.  Over all this program demon- */
/* strates many of the most useful mouse routines as well */
/* as some of the more useful video and window routines.  */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "pcwproto.h"

/**********************************************************/
/*                          Demo1                         */
/*                                                        */
/* Sets up a box which the mouse can not move out of and  */
/* continually updates the position of the mouse.  When   */
/* the left Mouse button pressed move the cursor to Mouse */
/* position and update cursor position line.              */
/**********************************************************/

void demo1(int tline, int bline) {

  static char *msg[] = {                           /* User messages */
     "Move the Mouse cursor  around and click",
     "the LEFT button. To end this demo click",
     "the RIGHT button",
     NULL
  };

  static char *mousepos[] = {
     "Mouse  Position: Row = %2d Col = %2d",       /* Some format strings */
     "Cursor Position: Row = %2d Col = %2d"
  };

   int mx_rows, mx_cols;                           /* Max rows & Cols */
   int row = 12, col = 40, bstatus;                /* Mouse Position */
   int urow =  6, ucol = 10;                       /* Box upper corner */
   int lrow = 18, lcol = 70;                       /* Box lower corner */
   WNDPTR *wnd;                                    /* A window handle */

   chk_video_state(&mx_rows, &mx_cols);            /* Get max rows & cols */
   set_cursor_size(tline,bline);
   set_mpos(row, col);                             /* Set mouse position */
   set_cursor_pos(row, col);                       /* Set cursor position */
   bordercolor(LIGHTBLUE, BLACK);                  /* Set border color */
   titlecolor(LIGHTGRAY, BLACK);
   setborder(SINGLESIDES);                         /* Set border type */
   wnd = wframe(urow,ucol,lrow,lcol,7,BLACK);      /* Make a window */
   wtitle(wnd, TOP, MIDDLE, " A Confined Mouse! ");/* Title the window */
   mframe(urow + 1, ucol + 1, lrow - 1, lcol - 1); /* Box in the Mouse */
   qprintf(urow - 2, CENTER, 15, 0, mousepos[0], row, col); /* Write pos */
   qprintf(urow - 1, CENTER,  4, 0, mousepos[1], row, col);
   q_block_write(19,20,RED,BLACK,msg);             /* Write user messages */
   show_mouse();
   do {
      get_mpos(&row, &col, &bstatus);              /* Get Mouse Position */
      qprintf(urow-2,99,15,0,mousepos[0],row, col);/* Write it out */
      if (get_mpressed(LEFT) > 0) {                /* Left Mouse button */
         set_cursor_pos(row, col);                 /* Move cursor there */
         qprintf(urow-1,99,4,0,mousepos[1],row,col);/* Write Cursor pos */
      }
   } while (get_mpressed(RITE) == NULL);       /* Unil Rite Mouse Button */
   hide_mouse();                               /* Hide the Mouse */
   wnd = wpop(wnd);                            /* Remove the Mouse */
   set_cursor_size(0,0);
   mframe(1, 1, mx_rows, mx_cols);             /* Remove Mouse constraint */
}

/**********************************************************/
/*                          Demo2                         */
/*                                                        */
/* Tell the user which Mouse Button was pressed.          */
/**********************************************************/

void demo2(void) {

  static char *msg[] = {
     "Move the Mouse Cursor Around Freely",      /* The user info */
     "and press  either  Mouse  button or",
     "press them together.  To  end  this",
     "demo press any key on the keyboard.",
     NULL
  };

  static char  *bstat[] = {
     " You Pressed the Left Button ",             /* Our messages */
     "You Pressed the Right Button ",
     "  You Pressed Both Buttons   "
  };

   WNDPTR *wnd;                                  /* A window handle */
   int    urow = 10, ucol = 22;                  /* Window upper corner */
   int    lrow = 15, lcol = 58;                  /* Window lower corner */
   int    row, col, bstatus;                     /* Mouse Info */

   set_mpos(1,1);                                /* Set Mouse position */
   vcls(); show_mouse();                         /* Cls and show mouse */
   bordercolor(RED, LIGHTGRAY);                  /* Set border color */
   titlecolor(BLUE, LIGHTGRAY);                  /* Set title color */
   wnd = wframe(urow, ucol-1, lrow, lcol+1, 0, 7);/* Frame a window */
   wtitle(wnd, TOP, LEFT, " Which Mouse Button? ");/*Title the window */
   w_block_write(wnd, 1, 2,msg); keybrd_flush();  /* Write msg/flush keboard */
   while(!keypressed()) {                        /* Do until we press a key */
     if (get_mpressed(RITEM) || get_mpressed(LEFTM)) { /* Mouse ? */
        get_mpos(&row, &col, &bstatus);          /* Get Button Status */
        bstatus--;                               /* Adjust for index */
        hide_mouse();                            /* Hide the Mouse */
        switch(bstatus) {                        /* Make a decision */
           case 0 : qputs(lrow+1,99,WHITE,0,bstat[bstatus]); break;
           case 1 : qputs(lrow+1,99,RED,0,bstat[bstatus]);   break;
           case 2 : qputs(lrow+1,99,GREEN,0,bstat[bstatus]); break;
        }
        show_mouse();                            /* Turn on the Mouse */
      }
  }
  keybrd_flush();                                /* Flush out keyboard */
  hide_mouse();                                  /* Rats to their holes! */
  wnd = wpop(wnd);                               /* Remove Window */
  vcls();                                        /* Clear the screen */
}                                                /* We are done. */

/**********************************************************/
/*                           Demo3                        */
/*                                                        */
/* More of a window demo than anything else.  Move the    */
/* window to the mouse position when the left mouse button*/
/* has been pressed.                                      */
/**********************************************************/

void demo3(WNDPTR **mwnd) {

    WNDPTR *wnd;
    int    urow = 1, ucol = 19;
    int    lrow = 7, lcol = 61;
    int    i=0, row, col, bstatus;

    static char format[] = "Move %d";
    static char   *msg[] = {
        "Move the  Mouse  Cursor  freely.  Press",
        "the LEFT  Mouse  key to move the window",
        "around on the screen. Press  the  RIGHT",
        "Mouse key to end the demo.             ",
        NULL
    };

    *mwnd = wpop(*mwnd);                     /* Show original screen */
    set_mpos(1,1); show_mouse(); setborder(2);
    wnd = wframe(urow,ucol,lrow,lcol,YELLOW,LIGHTGRAY);
    wtitle(wnd, BOTTOM, RITE, " Moving Windows ");
    w_block_write(wnd, 1,2,msg);             /* Write the message */
    set_wnd_attr(wnd,RED,LIGHTGRAY);         /* Change window attriutes */
    while (get_mpressed(RITE) == 0) {        /* Do until RITE button pressed */
       if (get_mpressed(LEFT) > 0) {         /* If LEFT button pressed */
          get_mpos(&row, &col, &bstatus);    /* Get Mouse position */
          hide_mouse();                      /* Rats to your holes! */
          wndmove(wnd, row, col);            /* Move the window */
          wprintf(wnd,5,CENTER,format,++i);  /* Tell how many times */
          show_mouse();                      /* Jerry come out Tom is gone! */
       }
    }
    hide_mouse();                            /* Hide the mouse */
    wnd = wpop(wnd);                         /* Remove the window */
}

/* Program Initialization */

int init_ms2test(WNDPTR **wnd,int *tline,int *bline) {

    int  arg2;
    int  mxr, mxc;

    if (!chk_video_state(&mxr, &mxc)) return(0);
    if (init_mouse() == 0) {
       vcls();
       qputs(12,30,RED,BLACK,"Shame on You!  You have");
       qputs(13,30,RED,BLACK,"Not Installed Your Mouse!");
       return(0);
     }
     if (_adaptor > CGA) fload(0,8);
     *wnd = wpush(1,1,mxr,mxc);
     if (wnd == NULL) return(0);
     get_cursor_size(tline,bline); vcls();
     arg2 = MK_ATTR(YELLOW+BLINK,BLACK) | 4;
     set_mtype(0,0,arg2);
     return(1);
}

void end_mouse_demo(int tline, int bline) {

   set_cursor_size(tline,bline);
   hide_mouse(); init_mouse();
   if (_adaptor > CGA) (_adaptor == EGA) ? fload(0,14):fload(0,16);
}

int main(void) {

    WNDPTR *wnd;
    int    tline, bline;

    if (init_ms2test(&wnd,&tline,&bline) == 0) exit(3);
    demo1(tline,bline); demo2(); demo3(&wnd);
    end_mouse_demo(tline,bline);
    return(0);
}
