/**********************************************************/
/* File Id.                  Cursor.C                     */
/* Author.                   Stan Milam.                  */
/* Date Written.             04/05/89.                    */
/*                                                        */
/*           (c) Copyright 1989-90 by Stan Milam          */
/*                                                        */
/* Comments: Routines that affect the cursor.             */
/**********************************************************/

#include <dos.h>
#include <string.h>
#include "pcwproto.h"

#ifndef NULL
#define NULL 0
#endif

static union REGS regs;
static int cols, mode, apage;

void set_cursor_size(int tline, int bline) {

    if (!ispcwinit()) pcwinit(AUTOEXIT);
    memset(&regs, '\0', sizeof(union REGS));
    if (tline == 0 && bline == 0) tline = 0x10;
    regs.x.ax = 0x0100;
    regs.h.ch = (char) tline;
    regs.h.cl = (char) bline;
    int86(0x10,&regs,&regs);
}

void get_cursor_size(int *tline, int *bline) {

    if (!ispcwinit()) pcwinit(AUTOEXIT);
    vgetmode(&cols, &mode, &apage);
    memset(&regs, '\0', sizeof(union REGS));
    regs.x.ax = 0x0300;
    regs.h.bh = (char) apage;
    int86(0x10, &regs, &regs);
    *tline = (int) regs.h.ch;
    *bline = (int) regs.h.cl;
}

void set_cursor_pos(int row, int col) {

    if (!ispcwinit()) pcwinit(AUTOEXIT);
    row--; col--;
    vgetmode(&cols, &mode, &apage);
    memset(&regs, '\0', sizeof(union REGS));
    regs.x.ax = 0x0200;
    regs.h.bh = (char) apage;
    regs.h.dh = (char) row;
    regs.h.dl = (char) col;
    int86(0x10,&regs, &regs);
}

void get_cursor_pos(int *row, int *col) {

    if (!ispcwinit()) pcwinit(AUTOEXIT);
    vgetmode(&cols, &mode, &apage);
    memset(&regs, '\0', sizeof(union REGS));
    regs.x.ax = 0x0300;
    regs.h.bh = (char) apage;
    int86(0x10, &regs, &regs);
    *row = (int) ++regs.h.dh;
    *col = (int) ++regs.h.dl;
}

int vgetchr(void) {

   int row, col;

   if (!ispcwinit()) pcwinit(AUTOEXIT);
   get_cursor_pos(&row, &col);
   memset(&regs, '\0', sizeof(union REGS));
   regs.h.ah = 8;
   regs.h.bh = (char) getpage();
   int86(0x10,&regs,&regs);
   return((int) regs.h.al);
}
