/*
 *                              MDM_INIT.C
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

#include <stdio.h>
#include <ctype.h>
#include "8250xon.h"
#include "ctrl_brk.h"
#include "timer.h"

#if (!defined (TRUE))
#	define TRUE (1)
#	define FALSE (0)
#endif

#define ETX 3
#define EOT 4
void usage (void);

main (int argc, char **argv)
{
    char    m_cmd[80];
    int     port = 1, baud = 0, data = 0, stop = 0, parity = 0,
            p_init = FALSE;
    while (argc > 1)
    {
    	if (*argv [1] == '?')
    		usage ();
        if (argv [1] [0] != '-')
        {
            break;
        }
        argc--; argv++;
        switch (toupper (argv[0][1]))
        {
            case 'B':
                baud = atoi (&argv[0][2]);
                break;
            case 'C':
                port = atoi (&argv[0][2]);
                break;
            case 'P':
                parity = argv[0][2];
                break;
            case 'S':
                stop = atoi (&argv[0][2]);
                break;
            case 'D':
                data = atoi (&argv[0][2]);
                break;
            default:
                fprintf (stderr, "Invalid option %s\n", *argv);
                usage ();
                break;
        }
    }


	if (baud || data || parity || stop)
	{
	    baud = (baud) ? baud : 1200;
	    data = (data) ? data : 8;
	    parity = (parity) ? toupper (parity) : (int) 'N';
	    stop = (stop) ? stop : 1;
	    sprintf (m_cmd, "%d %c %d %d", baud, parity, stop, data);
	    p_init = TRUE;
	}
    trap_ctrl_break ();
	timer_init ();
    xon8250_init (port, 256);
    if (p_init)
		xon8250_port_init (m_cmd);
	else
		xon8250_port_enable ();
    modem_write ("#+++");
    timeout (1);
    while (argc-- > 1)
    {
        modem_write ("AT");
        modem_write (*++argv);
        modem_write ("\r");
    }
    while (!xon8250_write_buffer_empty ())
		;
	timeout (1);
    xon8250_term (0);
    timer_term ();
    release_ctrl_break ();
    exit (0);
}




int
modem_write (char *s)
{
    char    ch, *cp;
    for (cp = s; *cp; cp++)
    {
        switch (*cp)
        {
            case '~':
                timeout (1);
                continue;
            case '#':
            	xon8250_dtnr ();
            	continue;
            case '^':
                ch = *++cp;
                ch = toupper (ch) - '@';
                while (xon8250_write (ch) == -1)
					;
                break;
            case '\\':
                switch (ch = *++cp)
                {
                    case 'e':
                        ch = 0x1b;
                        break;
                    case 'r':
                        ch = '\r';
                        break;
                    case 'n':
                        ch = '\n';
                        break;
                    case 'b':
                        ch = '\b';
                        break;
                    case 'a':
                        ch = '\a';
                        break;
                    case 'f':
                        ch = '\f';
                        break;
                    default:
                        break;
                }
                while (xon8250_write (ch) == -1)
					;
                break;
            default:
                while (xon8250_write (*cp) == -1)
					;
                break;
        }
    }
}

void
usage (void)
{
	fputs ("MDM_INIT:\n", stderr);
    fputs ("Use the following command line options.\n\n", stderr);
    fputs ("   -C[1 or 2] Com Port 1 or 2      {Default Com Port 1}\n", stderr);
    fputs ("   -B[300 600 1200 2400 4800 9600] {Default 9600 Baud}\n", stderr);
    fputs ("   -D[7 or 8]  Data Bits           {Default 8}\n", stderr);
    fputs ("   -S[1 or 2] Stop Bits            {Default 1}\n", stderr);
    fputs ("   -P[E O or N] Parity             {Default None}\n\n", stderr);
    fputs ("   -b2400 -pn -s1 -d8 -c1\n\n", stderr);
    fputs ("If any port options are set then the port will be left\n", stderr);
    fputs ("in that state when the program exits, otherwise we just\n", stderr);
    fputs (" enable the port and blast the strings we are passed to it\n\n", stderr);
    exit (1);
}

